/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 8, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

import java.util.logging.Level;

/**
 * @author       DNS
 *
 * Single precision binary floating point number represented in IEEE 754:1985 
 * 32-bit Floating Point Number Format.
 * 
 * @see http://en.wikipedia.org/wiki/IEEE_754
 */
public class DataElement_FD 
extends DataElement<Double>
{
	private Double value = null;
	
	public DataElement_FD(DataElementFactory instantiatingFactory, DataElementTag dataElementTag,
            DicomDictionaryEntry dictionaryEntry, long valueLength, byte[] value) 
	throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
    }

	public DataElement_FD(DataElementFactory instantiatingFactory, DataElementTag dataElementTag,
            ValueRepresentation explicitVRField, long valueLength, byte[] value) 
	throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
    }

	@Override
	protected void parseRawValue() 
	throws ValueRepresentationInterpretationException
    {
		if(getRawValue() == null)
			value = new Double(0);
		
		try
        {
			long bits = getInstantiatingFactory().getTransferSyntaxUid().makeUnsignedLongFrom8Bytes(getRawValue());
			value = new Double( Double.longBitsToDouble(bits) );
        } 
		catch (Exception e)
        {
			getLogger().log(Level.WARNING, "");
			throw new ValueRepresentationInterpretationException("Value '" + getRawValue()+ "' could not be interpreted as a Floating Point String");
        }
	    
    }

	/**
	 * @see gov.va.med.imaging.dicom.DataElement#getValue()
	 */
	@Override
	public Double getValue()
	{
		return value;
	}
}
