/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 7, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.DicomDateFormat;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomDateFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

/**
 * The Date Time common data type. Indicates a concatenated date-time ASCII string in the 
 * format: YYYYMMDDHHMMSS.FFFFFF&ZZZZThe components of this string, from left to right, 
 * are YYYY = Year, MM = Month, DD = Day, HH = Hour, MM = Minute, SS = Second, 
 * FFFFFF = Fractional Second, & = + or -, and ZZZZ = Hours and Minutes of offset. 
 * &ZZZZ is an optional suffix for plus/minus offset from Coordinated Universal Time. 
 * A component that is omitted from the string is termed a null component. Trailing null components 
 * of Date Time are ignored. Non-trailing null components are prohibited, given that the optional suffix 
 * is not considered as a component.
 * Note: For reasons of backward compatibility with versions of this standard prior to V3.0, 
 * many existing DICOM Data Elements use the separate DA and TM VRs. Standard and Private Data Elements 
 * defined in the future should use DT, when appropriate, to be more compliant with ANSI HISPP MSDS.
 * 
 * '0'-'9', '+', '-', '.' of Default Character Repertoire",
 * 
 * @author DNS
 *
 */
public class DataElement_DT 
extends DataElement<Date>
{
	private DateFormat df = new DicomDateFormat();
	private Date value = null;

	public DataElement_DT(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, DicomDictionaryEntry dictionaryEntry,
		long valueLength, byte[] rawValue) 
	throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, rawValue);
    }

	public DataElement_DT(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, ValueRepresentation explicitVRField,
		long valueLength, byte[] rawValue) 
	throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, rawValue);
    }

	/**
     * @throws DicomDateFormatException
     */
	@Override
    protected void parseRawValue() 
    throws DicomDateFormatException
    {
	    String tmp = new String(getRawValue());
	    try
        {
			value = df.parse(tmp);
        } 
	    catch (ParseException e)
        {
	    	throw new DicomDateFormatException(tmp);
        }
    }

	@Override
    public Date getValue() 
	throws ValueRepresentationInterpretationException
    {
	    return value;
    }
}
