/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 7, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomDateFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

import java.math.BigDecimal;

/**
 * @author DNS
 *
 * A string of characters representing either a fixed point number or a floating point number. 
 * A fixed point number shall contain only the characters 0-9 with an optional leading '+' or '-' 
 * and an optional '.' to mark the decimal point. 
 * A floating point number shall be conveyed as defined in ANSI X3.9, with an 'E' or 'e' to 
 * indicate the start of the exponent. Decimal Strings may be padded with leading or trailing spaces. 
 * Embedded spaces are not allowed.
 * Note: Data Elements with multiple values using this VR may not be properly encoded if Explicit-VR 
 * transfer syntax is used and the VL of this attribute exceeds 65534 bytes.
 * 
 * '0'-'9', '+', '-', E, 'e', '.' of Default Character Repertoire
 */
public class DataElement_DS 
extends DataElement<BigDecimal[]>
{
	private BigDecimal[] value = null;

	public DataElement_DS(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, DicomDictionaryEntry dictionaryEntry,
		long valueLength, byte[] rawValue) 
	throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, rawValue);
    }

	public DataElement_DS(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, ValueRepresentation explicitVRField,
		long valueLength, byte[] rawValue) 
	throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, rawValue);
    }

	/**
     * @throws DicomDateFormatException
     */
	@Override
    protected void parseRawValue() 
    throws DicomFormatException
    {
	    String tmp = transformValueToStringRemoveNulls(getRawValue(), getValueLength());
	    tmp = tmp.trim();
	    String[] tmpElements = tmp.split("\\\\");
	    value = new BigDecimal[tmpElements.length];
	    try
        {
		    for( int index=0; index < tmpElements.length; ++index )
		    	value[index] = new BigDecimal(tmpElements[index]);
        } 
	    catch (NumberFormatException e)
        {
	    	getLogger().warning("The data element value '" + tmp + "' is not interpretable as a Decimal String value representation, ignoring...");
	    	//throw new DicomFormatException_DS(tmp);
        }
    }

	@Override
    public BigDecimal[] getValue() 
	throws ValueRepresentationInterpretationException
    {
	    return value;
    }
}
