/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 7, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.DicomDateFormat;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomDateFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

/**
 * A string of characters of the format yyyymmdd; where yyyy shall contain year, mm shall contain the 
 * month, and dd shall contain the day. This conforms to the ANSI HISPP MSDS Date common data type.
 * Example: 19930822 would represent August 22, 1993.
 * Notes: 1. For reasons of backward compatibility with versions of this standard prior to V3.0, 
 * it is recommended that implementations also support a string of characters of the format yyyy.mm.dd for 
 * this VR.
 * 2. See also DT VR in this table.
 * 0-9 of Default Character Repertoire. Note: For reasons specified in the previous column, 
 * implementations may wish to support the . character as well.
 * 
 * @author DNS
 *
 */
public class DataElement_DA 
extends DataElement<Date>
{
	private Date value;

	public DataElement_DA(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, DicomDictionaryEntry dictionaryEntry,
		long valueLength, byte[] rawValue) 
	throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, rawValue);
    }

	public DataElement_DA(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, ValueRepresentation explicitVRField,
		long valueLength, byte[] rawValue) 
	throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, rawValue);
    }

	/**
     * @throws DicomDateFormatException
     */
	@Override
    protected void parseRawValue() 
    throws DicomDateFormatException
    {
		DateFormat df = new DicomDateFormat();
		
		if(getRawValue() == null || getRawValue().length == 0)
			value = new Date(0L);
		else
		{
		    String tmp = new String(getRawValue());
		    try
	        {
				value = df.parse(tmp);
	        } 
		    catch (ParseException e)
	        {
		    	throw new DicomDateFormatException(tmp);
	        }
		}
    }

	@Override
    public Date getValue()
    {
	    return value;
    }
}
