/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 7, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationValueLengthInsufficientException;

/**
 * Ordered pair of 16-bit unsigned integers that is the value of a Data Element Tag.
 * Example: A Data Element Tag of (0018,00FF) would be encoded as a series of 4 bytes in a 
 * Little-Endian Transfer Syntax as 18H,00H,FFH,00H and in a Big-Endian Transfer Syntax as 00H,18H,00H,FFH.
 * Note: The encoding of an AT value is exactly the same as the encoding of a Data Element Tag as defined 
 * in Section 7.
 * not applicable
 * 
 * @author DNS
 *
 */
public class DataElement_AT 
extends DataElement<DataElementTag>
{

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param explicitVRField
	 * @param valueLength
	 * @param value
	 */
	public DataElement_AT(DataElementFactory instantiatingFactory, DataElementTag dataElementTag,
	        ValueRepresentation explicitVRField, long valueLength, byte[] value)
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param dictionaryEntry
	 * @param valueLength
	 * @param value
	 * @throws ValueRepresentationValueLengthInsufficientException 
	 */
	public DataElement_AT(DataElementFactory instantiatingFactory, DataElementTag dataElementTag,
	        DicomDictionaryEntry dictionaryEntry, long valueLength, byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}

	
	private DataElementTag dataElementTag = null;
	/**
	 * @see gov.va.med.imaging.dicom.DataElement#getValue()
	 */
	@Override
	public DataElementTag getValue() 
	throws ValueRepresentationInterpretationException
	{
		return dataElementTag;
	}

	@Override
	protected void parseRawValue()
    {
	    dataElementTag = new DataElementTag(
	    	getInstantiatingFactory().getTransferSyntaxUid().makeUnsignedIntFrom2Bytes(getRawValue(), 0),
	    	getInstantiatingFactory().getTransferSyntaxUid().makeUnsignedIntFrom2Bytes(getRawValue(), 2) );
    }

}
