/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 7, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException_AS;

import java.util.regex.Pattern;

/**
 * @author DNS
 *
 * A string of characters with one of the following formats -- 
 * nnnD, nnnW, nnnM, nnnY; 
 * where nnn shall contain the number of days for D, weeks for W, months for M, or years for Y.
 * Example: 018M would represent an age of 18 months.
 * 
 *  0-9, D, W, M, Y of Default Character Repertoire
 *
*/
public class DataElement_AS 
extends DataElement<String>
{
	private String value = null;
	private static final Pattern ageStringPattern = Pattern.compile("[\\d]{3}[DWMY]");
	
	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param explicitVRField
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException 
	 */
	public DataElement_AS(
		DataElementFactory instantiatingFactory, 
		DataElementTag dataElementTag, 
		ValueRepresentation explicitVRField,
        long valueLength, 
        byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param dictionaryEntry
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException 
	 */
	public DataElement_AS(
		DataElementFactory instantiatingFactory, 
		DataElementTag dataElementTag, 
		DicomDictionaryEntry dictionaryEntry,
	    long valueLength, 
	    byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}

	@Override
    protected void parseRawValue() 
	throws DicomFormatException
    {
		if(getRawValue() == null)
			value = null;
		
		validateLengthValues();
		
		String value = getRawValue() == null ? null : new String(getRawValue()).trim();
		if(value != null)
			if( !ageStringPattern.matcher(value).matches() )
				throw new DicomFormatException_AS(value);
    }

	public String getValue()
	{
		return value;
	}
}
