/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 7, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationValueLengthInsufficientException;

/**
 * A string of characters that identifies an Application Entity with leading and trailing spaces (20H) 
 * being non-significant.  A value consisting solely of spaces shall not be used.
 * 
 * Default Character Repertoire excluding character code 5CH (the BACKSLASH \\ in ISO-IR 6), 
 * and control characters LF, FF, CR and ESC.
 * 
 * @author DNS
 * 
 */
public class DataElement_AE 
extends DataElement<String>
{
	private String value = null;
	
	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param explicitVRField
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException 
	 */
	public DataElement_AE(
		DataElementFactory instantiatingFactory, 
		DataElementTag dataElementTag, 
		ValueRepresentation explicitVRField,
        long valueLength, 
        byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param dictionaryEntry
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException 
	 */
	public DataElement_AE(
		DataElementFactory instantiatingFactory, 
		DataElementTag dataElementTag, 
		DicomDictionaryEntry dictionaryEntry,
	    long valueLength, 
	    byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}

	@Override
    protected void parseRawValue() 
	throws DicomFormatException
    {
		if(getRawValue() == null)
			value = null;
		
		validateLengthValues();
		
		String value = getRawValue() == null ? null : new String(getRawValue()).trim();
		if(value != null)
			if(value.length() < getValueRepresentation()[0].getMinLengthOfValue())
				throw new ValueRepresentationValueLengthInsufficientException();
    }

	public String getValue()
	{
		return value;
	}
}
