/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Jul 21, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom;

/**
 * @author       DNS
 * 
 * Notes from the spec:
 * Standard Data Elements have an even Group Number that is not 0000, 0002, 0004, or 0006.
 *   Note: Usage of these groups is reserved for DIMSE Commands (see PS 3.7) and DICOM File Formats.
 * Private Data Elements have an odd Group Number that is not (0001,eeee), (0003,eeee), (0005,eeee), (0007,eeee), or (FFFF,eeee).
 *
 * Note: Although similar or related Data Elements often have the same Group Number; 
 * a Data Group does not convey any semantic meaning beginning with DICOM Version 3.0.
 * 
 * 
 */
public enum Group
{
	CommandGroup(0x0000),
	SOPCommonGroup(0x0000),
	MetaElementGroup(0x0002),
	PatientGroup(0x0000),
	StudyGroup(0x0000),
	SeriesGroup(0x0000),
	EquipmentGroup(0x0000),
	ImageGroup(0x0000);
	
	private int groupNumber;
	Group(int groupNumber)
	{
		this.groupNumber = groupNumber;
	}
	
	public int getGroupNumber()
	{
		return this.groupNumber;
	}
	
	public static Group findByGroupNumber(int groupNumber)
	{
		for(Group group : Group.values())
			if(group.getGroupNumber() == groupNumber)
				return group;
		
		return null;
	}
	
	public boolean isStandardGroup()
	{
		return 
			groupNumber % 2 == 0 && 
			groupNumber != 0x0000 && groupNumber != 0x0002 && groupNumber != 0x0004 && groupNumber != 0x0006;
	}
	
	public boolean isPrivateGroup()
	{
		return 
			groupNumber % 2 == 1 && 
			groupNumber != 0x0001 && groupNumber != 0x0003 && groupNumber != 0x0005 && groupNumber != 0x0007 && groupNumber != 0xFFFF;
	}
}
