/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone ( DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.dd;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class DataDictionaryRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements DataDictionaryRouter
 {
	private static DataDictionaryRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized DataDictionaryRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new DataDictionaryRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected DataDictionaryRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dd.DataDictionaryResult getDataDictionaryValues(
 			gov.va.med.imaging.exchange.business.dd.DataDictionaryQuery dataDictionaryQuery
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dd.DataDictionaryResult> command = (Command<gov.va.med.imaging.exchange.business.dd.DataDictionaryResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dd.DataDictionaryResult.class, 
	 				"GetDataDictionaryValuesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dd.DataDictionaryQuery.class 
		  			},
 					new Object[]{
				 		dataDictionaryQuery
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDataDictionaryValuesCommand");
		
      
        gov.va.med.imaging.exchange.business.dd.DataDictionaryResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dd.DataDictionaryFile getDataDictionaryFile(
 			java.lang.String fileNumber
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dd.DataDictionaryFile> command = (Command<gov.va.med.imaging.exchange.business.dd.DataDictionaryFile>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dd.DataDictionaryFile.class, 
	 				"GetDataDictionaryFileCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		fileNumber
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDataDictionaryFileCommand");
		
      
        gov.va.med.imaging.exchange.business.dd.DataDictionaryFile commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dd.DataDictionaryFile> getDataDictionaryFiles(
 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dd.DataDictionaryFile.class, 
 				"GetDataDictionaryFilesCommand",
 				"",
				new Class<?>[]{
				 	 
	  			},
				new Object[]{
			 		
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDataDictionaryFilesCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dd.DataDictionaryFile> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dd.DataDictionaryResultEntry getDataDictionaryValue(
 			gov.va.med.imaging.exchange.business.dd.DataDictionaryEntryQuery dataDictionaryEntryQuery
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dd.DataDictionaryResultEntry> command = (Command<gov.va.med.imaging.exchange.business.dd.DataDictionaryResultEntry>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dd.DataDictionaryResultEntry.class, 
	 				"GetDataDictionaryValueCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dd.DataDictionaryEntryQuery.class 
		  			},
 					new Object[]{
				 		dataDictionaryEntryQuery
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDataDictionaryValueCommand");
		
      
        gov.va.med.imaging.exchange.business.dd.DataDictionaryResultEntry commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String[] getFileManEntryByValue(
 			java.lang.String fileNum
 		 			, java.lang.String keyName
 		 			, java.lang.String keyValue
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String[]> command = (Command<java.lang.String[]>)getCommandFactory().createCommand(
	 				 java.lang.String[].class, 
	 				"GetFileManEntryByValueCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		fileNum,keyName,keyValue
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetFileManEntryByValueCommand");
		
      
        java.lang.String[] commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 }