/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Aug 12, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone  DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.vistaimagingdatasource.dd;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;

import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.core.interfaces.exceptions.SecurityException;
import gov.va.med.imaging.datasource.AbstractVersionableDataSource;
import gov.va.med.imaging.datasource.DataDictionaryDataSourceSpi;
import gov.va.med.imaging.datasource.exceptions.InvalidCredentialsException;
import gov.va.med.imaging.exchange.business.ResolvedSite;
import gov.va.med.imaging.exchange.business.Site;
import gov.va.med.imaging.exchange.business.dd.DataDictionaryEntryQuery;
import gov.va.med.imaging.exchange.business.dd.DataDictionaryFile;
import gov.va.med.imaging.exchange.business.dd.DataDictionaryFileField;
import gov.va.med.imaging.exchange.business.dd.DataDictionaryQuery;
import gov.va.med.imaging.exchange.business.dd.DataDictionaryResult;
import gov.va.med.imaging.exchange.business.dd.DataDictionaryResultEntry;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.url.vista.VistaQuery;
import gov.va.med.imaging.url.vista.exceptions.InvalidVistaCredentialsException;
import gov.va.med.imaging.url.vista.exceptions.VistaMethodException;
import gov.va.med.imaging.vistadatasource.common.VistaCommonUtilities;
import gov.va.med.imaging.vistadatasource.session.VistaSession;

/**
 * @author        DNS
 *
 */
public class VistaImagingDataDictionaryDataSourceService
extends AbstractVersionableDataSource 
implements DataDictionaryDataSourceSpi
{
	public final static String SUPPORTED_PROTOCOL = "vistaimaging";
	
	private final static Logger logger = 
		Logger.getLogger(VistaImagingDataDictionaryDataSourceService.class);
	
	public VistaImagingDataDictionaryDataSourceService(ResolvedArtifactSource resolvedArtifactSource, String protocol)
	{
		super(resolvedArtifactSource, protocol);
	}
	
	// to support local data source
	public VistaImagingDataDictionaryDataSourceService(ResolvedArtifactSource resolvedArtifactSource)
	{
		super(resolvedArtifactSource, SUPPORTED_PROTOCOL);
	}

	@Override
	public boolean isVersionCompatible() 
	throws SecurityException
	{
		return true;
	}

	@Override
	public DataDictionaryResult queryDataDictionary(
			DataDictionaryQuery dataDictionaryQuery) 
	throws MethodException, ConnectionException
	{
		VistaCommonUtilities.setDataSourceMethodVersionAndProtocol("queryDataDictionary", getDataSourceVersion(), SUPPORTED_PROTOCOL);
		logger.info("queryDataDictionary (" + dataDictionaryQuery.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		if ((dataDictionaryQuery.getFields().length==1) && (dataDictionaryQuery.getFields()[0].equals("*"))) {
			// substitute "*" with all field names
			DataDictionaryFileField[] fileFields = getDataDictionaryFileFields(dataDictionaryQuery.getFileNumber());
			DataDictionaryQuery dataDictionaryQuery2= new DataDictionaryQuery(
					dataDictionaryQuery.getFileNumber(),
					getFieldNumbers(fileFields),
					dataDictionaryQuery.getMaximumResults(),
					dataDictionaryQuery.getMoreParameter());
			dataDictionaryQuery = dataDictionaryQuery2;
		}
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();
			VistaQuery query = 
				VistaImagingDataDictionaryQueryFactory.createDDRListerQuery(dataDictionaryQuery);
			String rtn = localVistaSession.call(query);

			return VistaImagingDataDictionaryTranslator.translateDataDictionaryQuery(dataDictionaryQuery, rtn);
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}
	
	public DataDictionaryFile getDataDictionaryFile(String fileNumber)
	throws MethodException, ConnectionException
	{
		VistaCommonUtilities.setDataSourceMethodVersionAndProtocol("getDataDictionaryFile", getDataSourceVersion(), SUPPORTED_PROTOCOL);
		logger.info("getDataDictionaryFile () TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();
			List<DataDictionaryFile> allFiles = getDataDictionaryFilesInternal(localVistaSession);
			for (DataDictionaryFile file:allFiles)
			{
				if (file.getNumber().equals(fileNumber)){
					file.getFields().addAll(Arrays.asList(getDataDictionaryFileFieldsInternal(localVistaSession, fileNumber)));
					for (DataDictionaryFileField field:file.getFields())
					{
						addDataDictionaryFileFieldAttributes(localVistaSession, field);
					}
					return file;
				}
			}
			return null;
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}
	
	private DataDictionaryFileField addDataDictionaryFileFieldAttributes(VistaSession localVistaSession, DataDictionaryFileField field) 
	throws IOException, InvalidVistaCredentialsException, VistaMethodException	
	{
		VistaQuery query = 
			VistaImagingFileManQueryFactory.createFileManAttributesQuery(
					field.getFileNumber(), field.getFieldNumber());
		String rtn = localVistaSession.call(query);
		VistaImagingFileManTranslator.translateDataDictionaryFileFieldAttributes(field, rtn);
		logger.info("Translated VistaResult into DataDictionaryFileField");
		return field;
	}
	
	@Override
	public List<DataDictionaryFile> getDataDictionaryFiles()
	throws MethodException, ConnectionException
	{
		VistaCommonUtilities.setDataSourceMethodVersionAndProtocol("getDataDictionaryFiles", getDataSourceVersion(), SUPPORTED_PROTOCOL);
		logger.info("getDataDictionaryFiles () TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();
			return getDataDictionaryFilesInternal(localVistaSession);
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}
	
	private List<DataDictionaryFile> getDataDictionaryFilesInternal(VistaSession localVistaSession) 
	throws IOException, InvalidVistaCredentialsException, VistaMethodException
	{
		VistaQuery query = 
			VistaImagingDataDictionaryQueryFactory.createGetFilesQuery();
		String rtn = localVistaSession.call(query);
		List<DataDictionaryFile> result = 
			VistaImagingDataDictionaryTranslator.translateDataDictionaryFileList(rtn);
		logger.info("Translated VistaResult into '" + result.size() + "' file entries");
		return result;
	}

	@Override
	public DataDictionaryResultEntry getDataDictionaryValue(
			DataDictionaryEntryQuery dataDictionaryEntryQuery)
	throws MethodException, ConnectionException
	{
		VistaCommonUtilities.setDataSourceMethodVersionAndProtocol("getDataDictionaryValue", getDataSourceVersion(), SUPPORTED_PROTOCOL);
		logger.info("getDataDictionaryValue (" + dataDictionaryEntryQuery.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		if ((dataDictionaryEntryQuery.getFields().length==1) && (dataDictionaryEntryQuery.getFields()[0].equals("*"))) {
			// substitute "*" with all field names
			DataDictionaryFileField[] fileFields = getDataDictionaryFileFields(dataDictionaryEntryQuery.getFileNumber()); 
			
			DataDictionaryEntryQuery dataDictionaryEntryQuery2= new DataDictionaryEntryQuery(
					dataDictionaryEntryQuery.getFileNumber(),
					getFieldNumbers(fileFields),
					dataDictionaryEntryQuery.getIen());
			dataDictionaryEntryQuery = dataDictionaryEntryQuery2;
		}
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();
			VistaQuery query = 
				VistaImagingDataDictionaryQueryFactory.createGetEntryValue(dataDictionaryEntryQuery);
			String rtn = localVistaSession.call(query);
			DataDictionaryResultEntry result = 
				VistaImagingDataDictionaryTranslator.translateDataDictionaryResultEntry(dataDictionaryEntryQuery, rtn);
			//logger.info("Translated VistaResult into '" + result.toString() + "' file entries");
			return result;
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

	@Override
	public DataDictionaryFileField[] getDataDictionaryFileFields(String fileNumber)
	throws MethodException, ConnectionException
	{
		VistaCommonUtilities.setDataSourceMethodVersionAndProtocol("getFileManFileFields", getDataSourceVersion(), SUPPORTED_PROTOCOL);
		logger.info("getFileManFileFields (" + fileNumber + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();
			return getDataDictionaryFileFieldsInternal(localVistaSession, fileNumber);
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}
	
	private DataDictionaryFileField[] getDataDictionaryFileFieldsInternal(VistaSession localVistaSession, String fileNumber) 
	throws IOException, InvalidVistaCredentialsException, VistaMethodException
	{
		VistaQuery query = 
			VistaImagingFileManQueryFactory.createGetFileManFieldsQuery(fileNumber);
		String rtn = localVistaSession.call(query);
		DataDictionaryFileField[] result = 
			VistaImagingDataDictionaryTranslator.translateFileFields(fileNumber, rtn);
		return result;
	}

	@Override
	public String[] getFileManEntryByValue(String fileNumber, String keyName, String keyValue)
	throws MethodException, ConnectionException
	{
		VistaCommonUtilities.setDataSourceMethodVersionAndProtocol("getFileManEntryByValue", getDataSourceVersion(), SUPPORTED_PROTOCOL);
		logger.info("getFileManEntryByValue (" + fileNumber + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();
			VistaQuery query = 
				VistaImagingFileManQueryFactory.createGetFileManEntryByValue(fileNumber, keyName, keyValue);
			String rtn = localVistaSession.call(query);
			String [] iens = 
				VistaImagingFileManTranslator.translateFileSearchResult(rtn);
			//logger.info("Translated VistaResult into '" + result.toString() + "' field entries");
			return iens;
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}
	
	protected String[] getFieldNumbers(DataDictionaryFileField[] fields){
		String[] result = new String[fields.length];
		for (int i=0;i<fields.length;i++){
			result[i] = fields[i].getFieldNumber();
		}
		return result;
	}
	
	protected String getDataSourceVersion()
	{
		return "1";
	}
	
	private VistaSession getVistaSession() 
    throws IOException, ConnectionException, MethodException
    {
	    return VistaSession.getOrCreate(getMetadataUrl(), getSite());
    }
	
	protected ResolvedSite getResolvedSite()
	{
		return (ResolvedSite)getResolvedArtifactSource();
	}
	
	protected Site getSite()
	{
		return getResolvedSite().getSite();
	}

}
