package gov.va.med.imaging.mix.business;

import gov.va.med.imaging.exchange.enums.ObjectOrigin;
import gov.va.med.imaging.mix.business.fhir.Instance;

import java.io.Serializable;
import java.util.Comparator;

/**
 * A Comparator class to assure that the images in a series remain in order of ien
 * 
 * @author DNS DNS
 *
 */
public class InstanceComparator implements Comparator<Instance>, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -4742160600868516301L;

	/**
	 * 
	 */
	@Override
	public int compare(Instance instance1, Instance instance2)
	{
		if(instance1 == null && instance2 != null)
			return 1;
		else if(instance1 != null && instance2 == null)
			return -1;
		else if(instance1 == null && instance2 == null)
			return 0;
		
		/*
		int dicomImageNumberRelation = image2.getImageNumber().compareTo(image1.getImageNumber());
		int dicomImageUidRelation = image2.getImageUid().compareTo(image1.getImageUid());
		int imageIenRelation = image2.getIen().compareTo(image1.getIen());
		*/
		// not sure if it should be image1 - image2, or image2 - image1, 
		// with image2 - image1, DOD images came in wrong order. Will this change have an effect on VA images?
		
		
		if((instance1.getObjectOrigin() == ObjectOrigin.DOD) || 
			(instance2.getObjectOrigin() == ObjectOrigin.DOD)) 
		{
			int dicomImageNumberRelation = 0;
			
			try
			{
				Integer instance1ImageNumber = Integer.parseInt(instance1.getNumber());
				Integer instance2ImageNumber = Integer.parseInt(instance2.getNumber());
				dicomImageNumberRelation = instance1ImageNumber.compareTo(instance2ImageNumber);
			}
			catch(Throwable t) {}
		
			int dicomImageUidRelation = 
				instance1.getUid() == null ? 
					(instance2.getUid() == null ? 0 : 1) :  
					instance1.getUid().compareTo(instance2.getUid());
					
			int instanceIenRelation = 
				instance1.getIen() == null ? 
					(instance2.getIen() == null ? 0 : 1) :
					instance1.getIen().compareTo(instance2.getIen());
			
			// if the instance is from the DOD then the ien field (Id) does not necessarily contain useful sorting information (since it is Base64+ encoded)
			// if the dicom image id and dicom UID are not 0, then use only these two fields to sort by.
			return dicomImageNumberRelation != 0 ? dicomImageNumberRelation : 
				dicomImageUidRelation != 0 ? dicomImageUidRelation : 
					instanceIenRelation;
			
		}
		else 
		{
			// JMW 3/12/08 - reversing the order of the sorts (was causing the images to be in descending order instead of ascending)
			
			int dicomImageNumberRelation = 0;
			
			try
			{
				Integer instance1ImageNumber = Integer.parseInt(instance1.getNumber());
				Integer instance2ImageNumber = Integer.parseInt(instance2.getNumber());
				dicomImageNumberRelation = instance1ImageNumber.compareTo(instance2ImageNumber);
			}
			catch(Throwable t) 
			{
				if(instance1.getNumber() != null)
				{
					dicomImageNumberRelation = instance1.getNumber().compareTo(instance2.getNumber());
				}
			}
			
			//int dicomImageNumberRelation = instance1.getNumber().compareTo(instance2.getNumber());
			// allow null ImageUID for non-dicom images
			int dicomImageUidRelation = instance1.getUid() != null && instance2.getUid() != null ?   
				instance1.getUid().compareTo(instance2.getUid()) :
				0;
			// JMW 3/12/08 - base32 decoding the IEN so it can be sorted properly
			// CTB 29Nov2009
			//int instanceIenRelation = Base32ConversionUtility.base32Decode(instance1.getIen()).compareTo(Base32ConversionUtility.base32Decode(instance2.getIen()));
			int instanceIenRelation = instance1.getIen().compareTo(instance2.getIen());
			/*
			return 	imageIenRelation != 0 ? imageIenRelation :
				dicomImageUidRelation != 0 ? dicomImageUidRelation : 
					dicomImageNumberRelation;
			*/
			// JMW 9/26/08 - images IENs do NOT always indicate proper order for the images
			return 	dicomImageNumberRelation != 0 ? dicomImageNumberRelation :
				instanceIenRelation != 0 ? instanceIenRelation : 
					dicomImageUidRelation;
		}
	}

}
