package gov.va.med.imaging.mix.business;

import gov.va.med.imaging.mix.business.fhir.ImagingStudy;

import java.io.Serializable;
import java.util.Comparator;

/**
 * 
 * A Comparator class to assure that the two imaging Studies are identical 
 * 
 * @author DNS DNS
 *
 */
public class ImagingStudyComparator implements Comparator<ImagingStudy>, Serializable {
	
	private static final long serialVersionUID = 4739063635641777003L;

	public int compare(ImagingStudy iStudy1, ImagingStudy iStudy2)
	{
		int patientRelation = iStudy1.getPatientID().compareTo(iStudy2.getPatientID());
		int studyUidRelation = iStudy1.getUid().compareTo(iStudy2.getUid());
		
		return (patientRelation + studyUidRelation); // 0 - equals
	}
}
