/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: May 4, 2010
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.exchange.storage;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

/**
 * Buffer backed representation of the object. This is used for image conversion because we know the object has
 * to be in memory to be converted, might as well put into memory first
 * 
 * @author DNS
 *
 */
public class ByteBufferBackedObject 
{
	private final ByteBuffer buffer;
	private final int size;
	
	public ByteBufferBackedObject(ByteBuffer buffer, int size)
	{
		this.buffer = buffer;
		this.size = size;
	}

	/**
	 * Return the underlying buffer (not a copy)
	 * @return
	 */
	public ByteBuffer getBuffer() {
		return buffer;
	}

	public int getSize() {
		return size;
	}
	
	/**
	 * Open an input stream to the buffer. Always opens a new input stream to the buffer when called
	 * @return
	 */
	public InputStream openInputStreamToBuffer()
	{
		ByteArrayInputStream input = new ByteArrayInputStream(buffer.array(), 0, size);
		return input;
	}
}
