/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: May 6, 2010
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.exchange.storage;

import gov.va.med.imaging.exchange.business.ImageStreamResponse;
import gov.va.med.imaging.exchange.enums.ImageQuality;

/**
 * ImageStreamResponse that uses ByteBufferBacked streams, used internally in the image conversion
 * 
 * @author DNS
 *
 */
public class ByteBufferBackedImageStreamResponse 
extends ImageStreamResponse 
{
	public ByteBufferBackedImageStreamResponse(ByteBufferBackedImageInputStream imageStream)
	{
		super(imageStream);
	}
	
	public ByteBufferBackedImageStreamResponse(ByteBufferBackedImageInputStream imageStream, 
			ImageQuality imageQuality)
	{
		super(imageStream, imageQuality);
	}
	
	public ByteBufferBackedImageStreamResponse(ByteBufferBackedImageInputStream imageStream, 
			ByteBufferBackedInputStream txtStream, ImageQuality imageQuality)
	{
		super(imageStream, txtStream, imageQuality);
	}
	
	public ByteBufferBackedImageInputStream getImageStream() 
	{
		return (ByteBufferBackedImageInputStream)imageStream;
	}

	public ByteBufferBackedInputStream getTxtStream() 
	{
		return (ByteBufferBackedInputStream)txtStream;
	}
}
