/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Oct 12, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.exchange.business.vistarad;

import gov.va.med.RoutingToken;

/**
 * Contains the cache status of an exam site
 * 
 * @author vhaiswwerfej
 *
 */
public class ExamSiteCachedStatus 
{
	private final String patientIcn;
	private final RoutingToken routingToken;
	private final boolean cached;
	
	public ExamSiteCachedStatus(String patientIcn, RoutingToken routingToken, boolean cached) 
	{
		super();
		this.patientIcn = patientIcn;
		this.routingToken = routingToken;
		this.cached = cached;
	}

	/**
	 * @return the siteNumber
	 */
	public RoutingToken getRoutingToken() {
		return this.routingToken;
	}

	/**
	 * @return the cached
	 */
	public boolean isCached() {
		return cached;
	}

	/**
	 * @return the patientIcn
	 */
	public String getPatientIcn() {
		return patientIcn;
	}
}
