//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, vJAXB 2.1.10 in JDK 6 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2011.03.10 at 10:15:31 PM EST 
//


package gov.va.med.imaging.exchange.business.dicom.importer;

import gov.va.med.imaging.exchange.business.Patient;
import gov.va.med.imaging.exchange.business.Patient.PatientSex;
import gov.va.med.imaging.exchange.business.WorkItem;
import gov.va.med.imaging.exchange.business.WorkItemTags;
import gov.va.med.imaging.exchange.business.WorkListTypes;
import gov.va.med.imaging.exchange.business.dicom.DicomUtils;
import gov.va.med.imaging.exchange.business.dicom.InstrumentConfig;
import gov.va.med.imaging.utils.StringUtilities;

import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.io.xml.CompactWriter;

public class ImporterWorkItem 
{

	public static final String TAG_SOURCE = "Source";
	public static final String TAG_PATIENT_NAME = "PatientName";
	public static final String TAG_STUDY_DESCRIPTION = "StudyDescription";
	public static final String TAG_DICOM_CORRECT_INSTANCE_KEY = "DcmCrctInstKey";
	public static final String TAG_DICOM_CORRECT_FILE_1 = "DcmCrctPart1";
	public static final String TAG_DICOM_CORRECT_FILE_2 = "DcmCrctPart2";
	public static final String TAG_DICOM_CORRECT_FILE_3 = "DcmCrctPart3";
	public static final String TAG_ACCESSION_NUMBER = "AccessionNumber";
	public static final String TAG_STUDY_UID = "StudyUid";
	public static final String TAG_PATIENT_ID = "PatientId";
	public static final String TAG_ORIGIN_INDEX = "OriginIndex";
	public static final String TAG_MEDIA_CATEGORY = "MediaCategory";

	private int id;
    private String type;
    private String subtype;
    private String status;
    private String creatingUser;
    private String creatingUserDisplayName;
    private String creatingApplication;
    private String createdDate;
    private String updatingUser;
    private String updatingUserDisplayName;
    private String updatingApplication;
    private String lastUpdateDate;
    private String source;
    private String patientName;
    private String placeId;
    private String accessionNumber;
    private String studyUid;
    private String patientId;
    private String originIndex;
    private MediaCategory mediaCategory;
    private ImporterWorkItemDetailsReference workItemDetailsReference;
    private ImporterWorkItemDetails workItemDetails = null;

	public ImporterWorkItem() { }
    
    public static ImporterWorkItem buildShallowImporterWorkItem(WorkItem rawWorkItem)
    {
    	return new ImporterWorkItem(rawWorkItem, null);
    }

    public static ImporterWorkItem buildFullImporterWorkItem(WorkItem rawWorkItem, ImporterWorkItemDetails workItemDetails)
    {
    	return new ImporterWorkItem(rawWorkItem, workItemDetails);
    }

    private ImporterWorkItem(WorkItem rawWorkItem, ImporterWorkItemDetails workItemDetails)
    {
    	// Map all the simple properties
    	this.id = rawWorkItem.getId();
    	this.type = rawWorkItem.getType();
    	this.subtype = rawWorkItem.getSubtype();
    	this.status = rawWorkItem.getStatus();
    	this.creatingUser = rawWorkItem.getCreatingUser();
    	this.setCreatingUserDisplayName(rawWorkItem.getCreatingUserDisplayName());
    	this.creatingApplication = rawWorkItem.getCreatingApplication();
    	this.createdDate = rawWorkItem.getCreatedDate();
    	this.updatingUser = rawWorkItem.getUpdatingUser();
    	this.setUpdatingUserDisplayName(rawWorkItem.getUpdatingUserDisplayName());
    	this.setUpdatingApplication(rawWorkItem.getUpdatingApplication());
    	this.lastUpdateDate = rawWorkItem.getLastUpdateDate();
    	this.placeId = rawWorkItem.getPlaceId();
    	
    	this.source = getTagValue(rawWorkItem, TAG_SOURCE);
    	this.patientName = getTagValue(rawWorkItem, TAG_PATIENT_NAME);
    	this.originIndex = getTagValue(rawWorkItem, TAG_ORIGIN_INDEX);
    	
    	String mediaCategoryTagValue = getTagValue(rawWorkItem, TAG_MEDIA_CATEGORY);
    	if (mediaCategoryTagValue == null || mediaCategoryTagValue.trim().equals(""))
    	{
    		// No tag was set. Default to DICOM only, for legacy work items
    		this.mediaCategory = new MediaCategory(MediaCategories.DICOM);
    	}
    	else
    	{
    		// Tag value was set. Use it in the constructor.
    		this.mediaCategory = new MediaCategory(mediaCategoryTagValue);
    	}

    	this.accessionNumber = getTagValue(rawWorkItem, TAG_ACCESSION_NUMBER);
    	this.studyUid = getTagValue(rawWorkItem, TAG_STUDY_UID);
    	this.patientId = getTagValue(rawWorkItem, TAG_PATIENT_ID);
    	
		XStream xstream = ImporterUtils.getXStream();
		
    	// If we have a workItemDetails instance, set it on the object and set the parent work item ien
    	if (workItemDetails != null)
    	{
    		this.workItemDetails = workItemDetails;
        	workItemDetails.setParentWorkItemIen(this.getId());
    	}



    	// Convert the message, if it exists, into an ImporterWorkItemDetailsReference instance
    	if (rawWorkItem.getMessage() != null)
    	{
    		// Extract the message from the raw work item
    		String message = rawWorkItem.getMessage().trim();
    		
    		// Unescape mumps control characters
    		message = StringUtilities.unescapeMumpsString(message);
    		
        	if (!message.equals(""))
        	{
            	this.setWorkItemDetailsReference((ImporterWorkItemDetailsReference)xstream.fromXML(message));
        	}
    	}

    	// If this is a DicomCorrect workitem, and we have a work item details object (not a shallow work item),
    	// refresh the series and study information using the DicomCorrectFiles, since new files may have been 
    	// added since the last time the work item was accessed
    	if (getWorkItemDetails() != null && (ImporterWorkItemSubtypes.DicomCorrect.equals(getSubtype()) || 
    	     ImporterWorkItemSubtypes.NetworkImport.equals(getSubtype())))
    	{
    		// Now get the Dicom Correct File tags, and decode them
        	List<String> tagsPart1 = rawWorkItem.getTags().getValueList(TAG_DICOM_CORRECT_FILE_1);
        	List<String> tagsPart2 = rawWorkItem.getTags().getValueList(TAG_DICOM_CORRECT_FILE_2);
        	List<String> tagsPart3 = rawWorkItem.getTags().getValueList(TAG_DICOM_CORRECT_FILE_3);
        	List<DicomCorrectFile> dicomCorrectFiles = convertTagsToDicomCorrectFiles(
        			tagsPart1, tagsPart2, tagsPart3);

    		// Build the new Series and SopInstances using the DicomCorrectFiles objects and attach them
    		// to the study
    		populateStudyFromDicomCorrectFiles(dicomCorrectFiles);
    	}
    	
    }

	private String getTagValue(WorkItem rawWorkItem, String tagName) {
		
		String value = rawWorkItem.getTags().getValue(tagName);
		return (value!=null) ? value : "";
	}

	private void populateStudyFromDicomCorrectFiles(List<DicomCorrectFile> dicomCorrectFiles) 
	{
		// If workItemDetails is null, e.g. on WorkList page, don't even BOTHER.
		if (getWorkItemDetails() == null)
			return;
		
		// If we're here, we have workItem details. We can proceed to refresh the series and image data
		// Get the study. (There's one and only one per media bundle for DICOM Correct)
		Study study = getWorkItemDetails().getStudies().get(0);
			
		// Clear out all existing Series in the study. They'll be replaced with data from the 
		// DicomCorrectFiles
		study.clearAllSeries();

		// Create a hashmap of series so we can track whether we've already added a particular
		// series or not
		HashMap<String, Series> seriesMap = new HashMap<String, Series>();
		
		// Iterate over the DicomCorrectFiles and populate the study
		for (DicomCorrectFile dicomCorrectFile : dicomCorrectFiles)
		{
			Series series = seriesMap.get(dicomCorrectFile.getSeriesUid());
			if (series != null)
			{
				// The series is already in the map. Just add a new SopInstance to it
				SopInstance sopInstance = new SopInstance(
						dicomCorrectFile.getInstanceUid(), 
						dicomCorrectFile.getFilePath());
				
				series.getSopInstances().add(sopInstance);
			}
			else
			{
				// We have not yet seen this series. Create a series object, and add it to both the study
				// and the series map
				series = new Series(dicomCorrectFile.getSeriesUid(), 
						dicomCorrectFile.getSeriesDate(),
						dicomCorrectFile.getModality(),
						dicomCorrectFile.getSeriesNumber());
				
				seriesMap.put(series.getUid(), series);
				study.getSeries().add(series);
				
				// Create a SopInstance and attach it to the series
				SopInstance sopInstance = new SopInstance(
						dicomCorrectFile.getInstanceUid(), 
						dicomCorrectFile.getFilePath(),
						dicomCorrectFile.getTransferSyntaxUid());
				
				series.getSopInstances().add(sopInstance);
			}
		}
	}
    
    private List<DicomCorrectFile> convertTagsToDicomCorrectFiles(
    		List<String> tagsPart1,
    		List<String> tagsPart2,
    		List<String> tagsPart3) 
    {
    	//
    	// We had to store the DICOM correct info in 3 separate tags, keyed by generated filename,
    	// because each tag has to be less than 230 characters long (FileMan restriction).
    	// Create a hash map so that we can build up the collection of tags for each instance. Also
    	// store an arraylist of keys so that we can iterate over them in order once we have collated
    	// all the tags.
    	HashMap<String, List<String>> tagCollection = new HashMap<String, List<String>>();
    	ArrayList<String> keys = new ArrayList<String>();
    	
    	// Add the keys for each file, as well as the associated tag1
		for (String tag1 : tagsPart1) {
			String key = DicomCorrectFile.getKeyFromTag1(tag1);
			keys.add(key);
			List<String> valueList = new ArrayList<String>();
			valueList.add(tag1);
			tagCollection.put(key, valueList);
		}

		// Add part 2
		for (String tag2 : tagsPart2) {
			String key = DicomCorrectFile.getKeyFromTag2(tag2);
			tagCollection.get(key).add(tag2);

		}

		// Add part 3
		for (String tag3 : tagsPart3) {
			String key = DicomCorrectFile.getKeyFromTag3(tag3);
			tagCollection.get(key).add(tag3);
		}
	    	
    	List<DicomCorrectFile> dicomCorrectFiles = new ArrayList<DicomCorrectFile>();

    	// now that the tags have been collated create the files
    	for (String key : keys)
    	{
    		dicomCorrectFiles.add(DicomCorrectFile.decodeFromTagValues(tagCollection.get(key)));
    	}
    	
    	return dicomCorrectFiles;
	}

	public WorkItem getRawWorkItem()
    {
		WorkItem workItem = new WorkItem();
		
    	// Map all the simple properties
    	workItem.setId(this.getId());
    	workItem.setType(this.getType());
    	workItem.setSubtype(this.getSubtype());
    	workItem.setStatus(this.getStatus());
    	workItem.setCreatingUser(this.getCreatingUser());
    	workItem.setCreatingUserDisplayName(this.getCreatingUserDisplayName());
    	workItem.setCreatingApplication(this.getCreatingApplication());
    	workItem.setCreatedDate(this.getCreatedDate());
    	workItem.setUpdatingUser(this.getUpdatingUser());
    	workItem.setUpdatingUserDisplayName(this.getUpdatingUserDisplayName());
    	workItem.setUpdatingApplication(this.getUpdatingApplication());
    	workItem.setLastUpdateDate(this.getLastUpdateDate());
    	workItem.setPlaceId(this.getPlaceId());
    	
    	if (workItem.getTags() == null)
    	{
    		workItem.setTags(new WorkItemTags());
    	}
    	
    	addTag(workItem, TAG_SOURCE, this.getSource());
    	
    	if (this.getMediaCategory() != null)
    	{
       		addTag(workItem, TAG_MEDIA_CATEGORY, this.getMediaCategory().getCategory() + "");
    	}
    	
    	if (this.originIndex != null)
    	{
    		addTag(workItem, TAG_ORIGIN_INDEX, originIndex);
    	}

    	// If DICOM Correct or Network Import, use the patient name specified when the work Item was created.
    	// Otherwise, use the Staging Patient Name if available.
    	if (ImporterWorkItemSubtypes.DicomCorrect.equals(getSubtype()) 
    			|| ImporterWorkItemSubtypes.NetworkImport.equals(getSubtype()))
    	{
	    	if (this.patientName != null)
	    	{
	    		addTag(workItem, TAG_PATIENT_NAME, patientName);
	    	}
    	}
    	else
    	{
	    	if (this.workItemDetailsReference.getVaPatientFromStaging() != null)
	    	{
	    		addTag(workItem, TAG_PATIENT_NAME, workItemDetailsReference.getVaPatientFromStaging().getPatientName());
	    	}
    	}
    	
		XStream xstream = ImporterUtils.getXStream();

		// Add DICOM Correct related metadata
		addTag(workItem, TAG_ACCESSION_NUMBER, getAccessionNumber());
		addTag(workItem, TAG_STUDY_UID, getStudyUid());
		addTag(workItem, TAG_PATIENT_ID, getPatientId());
    	
    	// Finally, convert the ImporterWorkItemDetails, if it exists, into an xml string
    	if (getWorkItemDetailsReference() != null)
    	{
    		// Convert the details into an XML string
    		StringWriter sw = new StringWriter();
    		xstream.marshal(getWorkItemDetailsReference(),  new CompactWriter(sw));
    		String message = sw.toString();
    		
    		// Escape any common mumps characters, so that we don't blow up due to 
    		// unexpected delimiters, etc.
    		message = StringUtilities.escapeMumpsString(message);
    		
    		workItem.setMessage(message);

    	}
    	
    	return workItem;
    }

	private void addTag(WorkItem workItem, String key, String value) 
	{
		if (value!=null && value != "")
		{
			workItem.getTags().addTag(key, value);
		}
	}

	public static ImporterWorkItem createDicomCorrectWorkItem(String subtype, String source, 
			String patientName, String accessionNumber, String studyUid, String patientId, String patientDOB, String patientSex, String status, String applicationName,
			int networkLocationIen, String studyDate, String studyTime, String studyDescription, String mediaBundleStagingRootDirectory, String placeId, 
			String originIndex, InstrumentConfig instrument)
	{
		patientName = DicomUtils.reformatDicomName(patientName);
		
		ImporterWorkItem item = new ImporterWorkItem();
		item.setType(WorkListTypes.DicomImporter);
		item.setSubtype(subtype);
		item.setSource(source);
		item.setPatientName(patientName);
		item.setAccessionNumber(accessionNumber);
		item.setStudyUid(studyUid);
		item.setPatientId(patientId);
		item.setStatus(status);
		item.setCreatingUser("");
		item.setUpdatingUser("");
		item.setCreatingApplication(applicationName);
		item.setUpdatingApplication(applicationName);
		item.setPlaceId(placeId);
		item.setOriginIndex(originIndex);
		

		// Create the study list and add the study to it.
		List<Study> studies = new ArrayList<Study>();
		Study study = new Study();
		study.setIdInMediaBundle(1);
		study.setAccessionNumber(accessionNumber);
		study.setStudyDate(studyDate);
		study.setStudyTime(studyTime);
		study.setDescription(studyDescription);
		study.setUid(studyUid);
		study.setOriginIndex(originIndex);
		studies.add(study);

		// Create the work item details object and attach it
		ImporterWorkItemDetails details = new ImporterWorkItemDetails();
		details.setNetworkLocationIen(networkLocationIen);
		details.setMediaBundleStagingRootDirectory(mediaBundleStagingRootDirectory);
		details.setMediaBundleStaged(true);
		details.setStudies(studies);
		details.setInstrumentNickName(instrument.getNickName());
		details.setInstrumentService(instrument.getService());
		details.setInstrumentAcqLocation(instrument.getSiteId());
		item.setWorkItemDetails(details);
		
		// Create the work item details reference object and attach it
		ImporterWorkItemDetailsReference detailsRef = new ImporterWorkItemDetailsReference();
		detailsRef.setNetworkLocationIen(networkLocationIen);
		detailsRef.setMediaBundleStagingRootDirectory(mediaBundleStagingRootDirectory);
		item.setWorkItemDetailsReference(detailsRef);

		// Create and add the patient
		PatientSex sex = PatientSex.valueOfPatientSex(patientSex);
		Date dob = parseDicomDate(patientDOB);
		Patient patient = new Patient(patientName, "", "", sex, dob, patientId, "", null);
		study.setPatient(patient);

		
		return item;
	}
	
	public String serializeDetailsToXml()
	{
		if (this.getWorkItemDetails() != null)
		{
			XStream xstream = ImporterUtils.getXStream();
			return xstream.toXML(this.getWorkItemDetails());
		}
		else
		{
			return "";
		}
	}
	
	public ImporterWorkItemDetails deserializeDetailsFromXml(String detailsXml)throws XStreamException
	{
		if (detailsXml != null && !detailsXml.toString().trim().equals(""))
		{
			XStream xstream = ImporterUtils.getXStream();
	    	this.setWorkItemDetails((ImporterWorkItemDetails)xstream.fromXML(detailsXml));
	    	return this.getWorkItemDetails();
		}
		
		return null;
	}

	private static Date parseDicomDate(String patientDOB) 
	{
		Date date = null; 
		try 
		{    
			DateFormat formatter ; 
			formatter = new SimpleDateFormat("yyyyMMdd");
			date = (Date)formatter.parse(patientDOB);   
		}	 
		catch (ParseException e)
		{
			System.out.println("Exception :"+e);    
		} 	
		
		return date;
	}

	private static PatientSex decodePatientSex(String patientSex) {
		// TODO Auto-generated method stub
		return null;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getSubtype() {
		return subtype;
	}

	public void setSubtype(String subtype) {
		this.subtype = subtype;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getPlaceId() {
		return placeId;
	}

	public void setPlaceId(String placeId) {
		this.placeId = placeId;
	}

	public String getCreatingUser() {
		return creatingUser;
	}

	public void setCreatingUser(String creatingUser) {
		this.creatingUser = creatingUser;
	}

	public String getCreatingApplication() {
		return creatingApplication;
	}

	public void setCreatingApplication(String creatingApplication) {
		this.creatingApplication = creatingApplication;
	}

	public String getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(String createdDate) {
		this.createdDate = createdDate;
	}

	public String getUpdatingUser() {
		return updatingUser;
	}

	public void setUpdatingUser(String updatingUser) {
		this.updatingUser = updatingUser;
	}

	public String getLastUpdateDate() {
		return lastUpdateDate;
	}

	public void setLastUpdateDate(String lastUpdateDate) {
		this.lastUpdateDate = lastUpdateDate;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getPatientName() {
		return patientName.replace('^', ',');
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public ImporterWorkItemDetails getWorkItemDetails() {
		return workItemDetails;
	}

	public void setWorkItemDetails(ImporterWorkItemDetails workItemDetails) {
		this.workItemDetails = workItemDetails;
	}

	public void setAccessionNumber(String accessionNumber) {
		this.accessionNumber = accessionNumber;
	}

	public String getAccessionNumber() {
		return accessionNumber;
	}

	public void setStudyUid(String studyUid) {
		this.studyUid = studyUid;
	}

	public String getStudyUid() {
		return studyUid;
	}

	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}

	public String getPatientId() {
		return patientId;
	}

	public void setWorkItemDetailsReference(ImporterWorkItemDetailsReference workItemDetailsReference) {
		this.workItemDetailsReference = workItemDetailsReference;
	}

	public ImporterWorkItemDetailsReference getWorkItemDetailsReference() {
		return workItemDetailsReference;
	}

	public void setOriginIndex(String originIndex) {
		this.originIndex = originIndex;
	}

	public String getOriginIndex() {
		return originIndex;
	}

	public void setUpdatingApplication(String updatingApplication) {
		this.updatingApplication = updatingApplication;
	}

	public String getUpdatingApplication() {
		return updatingApplication;
	}

	public void setCreatingUserDisplayName(String creatingUserDisplayName) {
		this.creatingUserDisplayName = creatingUserDisplayName;
	}

	public String getCreatingUserDisplayName() {
		return creatingUserDisplayName;
	}

	public void setUpdatingUserDisplayName(String updatingUserDisplayName) {
		this.updatingUserDisplayName = updatingUserDisplayName;
	}

	public String getUpdatingUserDisplayName() {
		return updatingUserDisplayName;
	}

	/**
	 * @return the mediaCategory
	 */
	public MediaCategory getMediaCategory() {
		return mediaCategory;
	}

	/**
	 * @param mediaCategory the mediaCategory to set
	 */
	public void setMediaCategory(MediaCategory mediaCategory) {
		this.mediaCategory = mediaCategory;
	}    
}
