/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 30, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.exchange.business;

import java.io.Serializable;
import java.util.SortedSet;
import java.util.TreeSet;

/**
 * 
 * @author DNS
 *
 */
public class PassthroughInputMethod
implements Serializable
{
	private static final long serialVersionUID = 1L;
	private final String methodName;
	private final SortedSet<PassthroughParameter> parameters = new TreeSet<PassthroughParameter>();
	
	public PassthroughInputMethod(String methodName) 
	{
		super();
		this.methodName = methodName;
	}

	/**
	 * @return the methodName
	 */
	public String getMethodName() {
		return methodName;
	}

	/**
	 * @return the parameters
	 */
	public SortedSet<PassthroughParameter> getParameters() {
		return parameters;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() 
	{
		StringBuilder sb = new StringBuilder();
		
		sb.append("Method Name '" + getMethodName() + "'.");
		for(PassthroughParameter parameter : parameters)
		{
			sb.append("\t" + parameter);
		}
		
		return sb.toString();
	}	
}
