/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 30, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.datasource;

import gov.va.med.RoutingToken;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.datasource.annotations.SPI;
import gov.va.med.imaging.exchange.business.PassthroughInputMethod;

/**
 * @author DNS
 *
 */
@SPI(description="Blindly call a data source to get some data.  No advanced knowledge of the input or output is expected by the data source.")
public interface PassthroughDataSourceSpi 
extends VersionableDataSourceSpi
{

	/**
	 * Method to blindly call a data source to get some data.  No advanced knowledge of the input or output
	 * is expected by the data source.
	 * @param method
	 * @return
	 * @throws MethodException
	 * @throws ConnectionException
	 */
	public abstract String executePassthroughMethod(RoutingToken globalRoutingToken,
			PassthroughInputMethod method)
	throws MethodException, ConnectionException;
	
}
