/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.core.router.worklist;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class WorkListRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public WorkListRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void createWorkItem(
 			gov.va.med.imaging.exchange.business.WorkItem workItem
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostWorkItemCommand' and parameters 'gov.va.med.imaging.exchange.business.WorkItem'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.WorkItem.class, 
	 				"PostWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.WorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostWorkItemCommand' in method 'createWorkItem' with parameters 'gov.va.med.imaging.exchange.business.WorkItem'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getWorkItemList(
 			gov.va.med.imaging.exchange.business.WorkItemFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetWorkItemListCommand' and parameters 'gov.va.med.imaging.exchange.business.WorkItemFilter'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.WorkItem.class, 
 				"GetWorkItemListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.business.WorkItemFilter.class 
	  			},
				new Object[]{
			 		filter
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetWorkItemListCommand' in method 'getWorkItemList' with parameters 'gov.va.med.imaging.exchange.business.WorkItemFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void updateWorkItem(
 			int workItemId
 		 			, java.lang.String expectedStatus
 		 			, java.lang.String newStatus
 		 			, java.lang.String newMessage
 		 			, java.lang.String updatingUser
 		 			, java.lang.String updatingApplication
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutWorkItemCommand' and parameters 'int, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PutWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 int.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		workItemId,expectedStatus,newStatus,newMessage,updatingUser,updatingApplication
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutWorkItemCommand' in method 'updateWorkItem' with parameters 'int, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postWorkItemTags(
 			int workItemId
 		 			, java.util.List<java.lang.String> allowedStatuses
 		 			, java.util.List<gov.va.med.imaging.exchange.business.WorkItemTag> newTags
 		 			, java.lang.String updatedBy
 		 			, java.lang.String updatingApplication
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostWorkItemTagsCommand' and parameters 'int, java.util.List, java.util.List, java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostWorkItemTagsCommand",
	 				"",
 					new Class<?>[]{
				 		 int.class, java.util.List.class, java.util.List.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		workItemId,allowedStatuses,newTags,updatedBy,updatingApplication
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostWorkItemTagsCommand' in method 'postWorkItemTags' with parameters 'int, java.util.List, java.util.List, java.lang.String, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteWorkItem(
 			int id
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DeleteWorkItemCommand' and parameters 'int'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"DeleteWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 int.class 
		  			},
 					new Object[]{
				 		id
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DeleteWorkItemCommand' in method 'deleteWorkItem' with parameters 'int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getAndTransitionWorkItem(
 			int id
 		 			, java.lang.String expectedStatus
 		 			, java.lang.String newStatus
 		 			, java.lang.String updatingUser
 		 			, java.lang.String updatingApplication
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetAndTransitionWorkItemCommand' and parameters 'int, java.lang.String, java.lang.String, java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.WorkItem.class, 
	 				"GetAndTransitionWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 int.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		id,expectedStatus,newStatus,updatingUser,updatingApplication
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetAndTransitionWorkItemCommand' in method 'getAndTransitionWorkItem' with parameters 'int, java.lang.String, java.lang.String, java.lang.String, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getAndTransitionNextWorkItem(
 			java.lang.String type
 		 			, java.lang.String expectedStatus
 		 			, java.lang.String newStatus
 		 			, java.lang.String updatingUser
 		 			, java.lang.String updatingApplication
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetAndTransitionNextWorkItemCommand' and parameters 'java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.WorkItem.class, 
	 				"GetAndTransitionNextWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		type,expectedStatus,newStatus,updatingUser,updatingApplication
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetAndTransitionNextWorkItemCommand' in method 'getAndTransitionNextWorkItem' with parameters 'java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String'.");
 		}

 }