/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.core.router.storage;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class StorageDataSourceRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public StorageDataSourceRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postArtifact(
 			gov.va.med.imaging.exchange.business.storage.Artifact artifact
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostArtifactCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.Artifact'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"PostArtifactCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Artifact.class 
		  			},
 					new Object[]{
				 		artifact
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostArtifactCommand' in method 'postArtifact' with parameters 'gov.va.med.imaging.exchange.business.storage.Artifact'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postArtifactInstance(
 			gov.va.med.imaging.exchange.business.storage.ArtifactInstance artifactInstance
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostArtifactInstanceCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactInstance'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class, 
	 				"PostArtifactInstanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class 
		  			},
 					new Object[]{
				 		artifactInstance
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostArtifactInstanceCommand' in method 'postArtifactInstance' with parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactInstance'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postArtifactRetentionPolicy(
 			gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy artifactRetentionPolicy
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostArtifactRetentionPolicyCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy.class, 
	 				"PostArtifactRetentionPolicyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy.class 
		  			},
 					new Object[]{
				 		artifactRetentionPolicy
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostArtifactRetentionPolicyCommand' in method 'postArtifactRetentionPolicy' with parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postProviderAvailability(
 			gov.va.med.imaging.exchange.business.storage.ProviderAvailability providerAvailability
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostProviderAvailabilityCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ProviderAvailability'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.ProviderAvailability.class, 
	 				"PostProviderAvailabilityCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ProviderAvailability.class 
		  			},
 					new Object[]{
				 		providerAvailability
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostProviderAvailabilityCommand' in method 'postProviderAvailability' with parameters 'gov.va.med.imaging.exchange.business.storage.ProviderAvailability'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postProvider(
 			gov.va.med.imaging.exchange.business.storage.Provider provider
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostProviderCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.Provider'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Provider.class, 
	 				"PostProviderCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Provider.class 
		  			},
 					new Object[]{
				 		provider
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostProviderCommand' in method 'postProvider' with parameters 'gov.va.med.imaging.exchange.business.storage.Provider'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postRetentionPolicyFulfillment(
 			gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment retentionPolicyFulfillment
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostRetentionPolicyFulfillmentCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment.class, 
	 				"PostRetentionPolicyFulfillmentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment.class 
		  			},
 					new Object[]{
				 		retentionPolicyFulfillment
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostRetentionPolicyFulfillmentCommand' in method 'postRetentionPolicyFulfillment' with parameters 'gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postRetentionPolicyProviderMapping(
 			gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping mapping
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostRetentionPolicyProviderMappingCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping.class, 
	 				"PostRetentionPolicyProviderMappingCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping.class 
		  			},
 					new Object[]{
				 		mapping
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostRetentionPolicyProviderMappingCommand' in method 'postRetentionPolicyProviderMapping' with parameters 'gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postStorageTransaction(
 			gov.va.med.imaging.exchange.business.storage.StorageTransaction storageTransaction
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostStorageTransactionCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.StorageTransaction'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.StorageTransaction.class, 
	 				"PostStorageTransactionCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.StorageTransaction.class 
		  			},
 					new Object[]{
				 		storageTransaction
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostStorageTransactionCommand' in method 'postStorageTransaction' with parameters 'gov.va.med.imaging.exchange.business.storage.StorageTransaction'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStorageTransactionsWithinTimePeriod(
 			java.lang.String type
 		 			, java.lang.String status
 		 			, gov.va.med.imaging.exchange.business.TimePeriod period
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStorageTransactionsWithinTimePeriodCommand' and parameters 'java.lang.String, java.lang.String, gov.va.med.imaging.exchange.business.TimePeriod'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetStorageTransactionsWithinTimePeriodCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.business.TimePeriod.class 
		  			},
 					new Object[]{
				 		type,status,period
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStorageTransactionsWithinTimePeriodCommand' in method 'getStorageTransactionsWithinTimePeriod' with parameters 'java.lang.String, java.lang.String, gov.va.med.imaging.exchange.business.TimePeriod'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postTransferStatistics(
 			gov.va.med.imaging.exchange.business.storage.TransferStatistics transferStatistics
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostTransferStatisticsCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.TransferStatistics'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.TransferStatistics.class, 
	 				"PostTransferStatisticsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.TransferStatistics.class 
		  			},
 					new Object[]{
				 		transferStatistics
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostTransferStatisticsCommand' in method 'postTransferStatistics' with parameters 'gov.va.med.imaging.exchange.business.storage.TransferStatistics'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteProviderAvailability(
 			java.lang.Integer providerAvailabilityId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DeleteProviderAvailabilityCommand' and parameters 'java.lang.Integer'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"DeleteProviderAvailabilityCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.Integer.class 
		  			},
 					new Object[]{
				 		providerAvailabilityId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DeleteProviderAvailabilityCommand' in method 'deleteProviderAvailability' with parameters 'java.lang.Integer'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteRetentionPolicyProviderMapping(
 			java.lang.Integer mappingId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DeleteRetentionPolicyProviderMappingCommand' and parameters 'java.lang.Integer'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"DeleteRetentionPolicyProviderMappingCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.Integer.class 
		  			},
 					new Object[]{
				 		mappingId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DeleteRetentionPolicyProviderMappingCommand' in method 'deleteRetentionPolicyProviderMapping' with parameters 'java.lang.Integer'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getArtifactAndInstancesById(
 			java.lang.Integer artifactId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetArtifactAndInstancesByIdCommand' and parameters 'java.lang.Integer'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAndInstancesByIdCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.Integer.class 
		  			},
 					new Object[]{
				 		artifactId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetArtifactAndInstancesByIdCommand' in method 'getArtifactAndInstancesById' with parameters 'java.lang.Integer'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getArtifactAndInstancesByKeyList(
 			gov.va.med.imaging.exchange.business.storage.KeyList keyList
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetArtifactAndInstancesByKeyListCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.KeyList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAndInstancesByKeyListCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.KeyList.class 
		  			},
 					new Object[]{
				 		keyList
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetArtifactAndInstancesByKeyListCommand' in method 'getArtifactAndInstancesByKeyList' with parameters 'gov.va.med.imaging.exchange.business.storage.KeyList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getArtifactAndInstancesByToken(
 			java.lang.String artifactToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetArtifactAndInstancesByTokenCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAndInstancesByTokenCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetArtifactAndInstancesByTokenCommand' in method 'getArtifactAndInstancesByToken' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getArtifactAsGraphById(
 			java.lang.String artifactId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetArtifactAsGraphByIdCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAsGraphByIdCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetArtifactAsGraphByIdCommand' in method 'getArtifactAsGraphById' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getArtifactAsGraphByToken(
 			java.lang.String artifactToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetArtifactAsGraphByTokenCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAsGraphByTokenCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetArtifactAsGraphByTokenCommand' in method 'getArtifactAsGraphByToken' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getArtifactByToken(
 			java.lang.String artifactToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetArtifactByTokenCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactByTokenCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetArtifactByTokenCommand' in method 'getArtifactByToken' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getCurrentWriteLocation(
 			gov.va.med.imaging.exchange.business.storage.Provider provider
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetCurrentWriteLocationCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.Provider'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo.class, 
	 				"GetCurrentWriteLocationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Provider.class 
		  			},
 					new Object[]{
				 		provider
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetCurrentWriteLocationCommand' in method 'getCurrentWriteLocation' with parameters 'gov.va.med.imaging.exchange.business.storage.Provider'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getCurrentJukeboxWriteLocation(
 			gov.va.med.imaging.exchange.business.storage.Provider provider
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetCurrentJukeboxWriteLocationCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.Provider'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo.class, 
	 				"GetCurrentJukeboxWriteLocationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Provider.class 
		  			},
 					new Object[]{
				 		provider
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetCurrentJukeboxWriteLocationCommand' in method 'getCurrentJukeboxWriteLocation' with parameters 'gov.va.med.imaging.exchange.business.storage.Provider'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getNetworkLocationDetails(
 			java.lang.String networkLocationIEN
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetNetworkLocationDetailsCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo.class, 
	 				"GetNetworkLocationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		networkLocationIEN
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetNetworkLocationDetailsCommand' in method 'getNetworkLocationDetails' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStorageServerDatabaseConfiguration(
 			gov.va.med.imaging.exchange.business.storage.ProviderFactory providerFactory
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStorageServerDatabaseConfigurationCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ProviderFactory'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.StorageServerDatabaseConfiguration.class, 
	 				"GetStorageServerDatabaseConfigurationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ProviderFactory.class 
		  			},
 					new Object[]{
				 		providerFactory
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStorageServerDatabaseConfigurationCommand' in method 'getStorageServerDatabaseConfiguration' with parameters 'gov.va.med.imaging.exchange.business.storage.ProviderFactory'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void putArtifact(
 			gov.va.med.imaging.exchange.business.storage.Artifact artifact
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutArtifactCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.Artifact'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"PutArtifactCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Artifact.class 
		  			},
 					new Object[]{
				 		artifact
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutArtifactCommand' in method 'putArtifact' with parameters 'gov.va.med.imaging.exchange.business.storage.Artifact'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void putArtifactInstanceLastAccessed(
 			gov.va.med.imaging.exchange.business.storage.ArtifactInstance artifactInstance
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutArtifactInstanceLastAccessedCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactInstance'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class, 
	 				"PutArtifactInstanceLastAccessedCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class 
		  			},
 					new Object[]{
				 		artifactInstance
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutArtifactInstanceLastAccessedCommand' in method 'putArtifactInstanceLastAccessed' with parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactInstance'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void putArtifactInstanceUrl(
 			gov.va.med.imaging.exchange.business.storage.ArtifactInstance artifactInstance
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutArtifactInstanceUrlCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactInstance'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class, 
	 				"PutArtifactInstanceUrlCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class 
		  			},
 					new Object[]{
				 		artifactInstance
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutArtifactInstanceUrlCommand' in method 'putArtifactInstanceUrl' with parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactInstance'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void putArtifactRetentionPolicy(
 			gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy artifactRetentionPolicy
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutArtifactRetentionPolicyCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy.class, 
	 				"PutArtifactRetentionPolicyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy.class 
		  			},
 					new Object[]{
				 		artifactRetentionPolicy
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutArtifactRetentionPolicyCommand' in method 'putArtifactRetentionPolicy' with parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void putProviderAvailability(
 			gov.va.med.imaging.exchange.business.storage.ProviderAvailability providerAvailability
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutProviderAvailabilityCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ProviderAvailability'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.ProviderAvailability.class, 
	 				"PutProviderAvailabilityCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ProviderAvailability.class 
		  			},
 					new Object[]{
				 		providerAvailability
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutProviderAvailabilityCommand' in method 'putProviderAvailability' with parameters 'gov.va.med.imaging.exchange.business.storage.ProviderAvailability'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void putProvider(
 			gov.va.med.imaging.exchange.business.storage.Provider provider
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutProviderCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.Provider'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.Provider.class, 
	 				"PutProviderCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Provider.class 
		  			},
 					new Object[]{
				 		provider
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutProviderCommand' in method 'putProvider' with parameters 'gov.va.med.imaging.exchange.business.storage.Provider'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void putRetentionPolicy(
 			gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor artifactDescriptor
 		 			, gov.va.med.imaging.exchange.business.storage.RetentionPolicy retentionPolicy
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutRetentionPolicyCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor, gov.va.med.imaging.exchange.business.storage.RetentionPolicy'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.RetentionPolicy.class, 
	 				"PutRetentionPolicyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor.class, gov.va.med.imaging.exchange.business.storage.RetentionPolicy.class 
		  			},
 					new Object[]{
				 		artifactDescriptor,retentionPolicy
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutRetentionPolicyCommand' in method 'putRetentionPolicy' with parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor, gov.va.med.imaging.exchange.business.storage.RetentionPolicy'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void putRetentionPolicyProviderMapping(
 			gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping mapping
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutRetentionPolicyProviderMappingCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping.class, 
	 				"PutRetentionPolicyProviderMappingCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping.class 
		  			},
 					new Object[]{
				 		mapping
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutRetentionPolicyProviderMappingCommand' in method 'putRetentionPolicyProviderMapping' with parameters 'gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping'.");
 		}

 }