/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.core.router.storage;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class StorageDataSourceRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements StorageDataSourceRouter
 {
	private static StorageDataSourceRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized StorageDataSourceRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new StorageDataSourceRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected StorageDataSourceRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Artifact postArtifact(
 			gov.va.med.imaging.exchange.business.storage.Artifact artifact
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Artifact> command = (Command<gov.va.med.imaging.exchange.business.storage.Artifact>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"PostArtifactCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Artifact.class 
		  			},
 					new Object[]{
				 		artifact
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostArtifactCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Artifact commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.ArtifactInstance postArtifactInstance(
 			gov.va.med.imaging.exchange.business.storage.ArtifactInstance artifactInstance
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.ArtifactInstance> command = (Command<gov.va.med.imaging.exchange.business.storage.ArtifactInstance>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class, 
	 				"PostArtifactInstanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class 
		  			},
 					new Object[]{
				 		artifactInstance
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostArtifactInstanceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.ArtifactInstance commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy postArtifactRetentionPolicy(
 			gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy artifactRetentionPolicy
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy> command = (Command<gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy.class, 
	 				"PostArtifactRetentionPolicyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy.class 
		  			},
 					new Object[]{
				 		artifactRetentionPolicy
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostArtifactRetentionPolicyCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.ProviderAvailability postProviderAvailability(
 			gov.va.med.imaging.exchange.business.storage.ProviderAvailability providerAvailability
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.ProviderAvailability> command = (Command<gov.va.med.imaging.exchange.business.storage.ProviderAvailability>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.ProviderAvailability.class, 
	 				"PostProviderAvailabilityCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ProviderAvailability.class 
		  			},
 					new Object[]{
				 		providerAvailability
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostProviderAvailabilityCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.ProviderAvailability commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Provider postProvider(
 			gov.va.med.imaging.exchange.business.storage.Provider provider
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Provider> command = (Command<gov.va.med.imaging.exchange.business.storage.Provider>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Provider.class, 
	 				"PostProviderCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Provider.class 
		  			},
 					new Object[]{
				 		provider
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostProviderCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Provider commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment postRetentionPolicyFulfillment(
 			gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment retentionPolicyFulfillment
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment> command = (Command<gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment.class, 
	 				"PostRetentionPolicyFulfillmentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment.class 
		  			},
 					new Object[]{
				 		retentionPolicyFulfillment
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostRetentionPolicyFulfillmentCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.RetentionPolicyFulfillment commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping postRetentionPolicyProviderMapping(
 			gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping mapping
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping> command = (Command<gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping.class, 
	 				"PostRetentionPolicyProviderMappingCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping.class 
		  			},
 					new Object[]{
				 		mapping
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostRetentionPolicyProviderMappingCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.StorageTransaction postStorageTransaction(
 			gov.va.med.imaging.exchange.business.storage.StorageTransaction storageTransaction
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.StorageTransaction> command = (Command<gov.va.med.imaging.exchange.business.storage.StorageTransaction>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.StorageTransaction.class, 
	 				"PostStorageTransactionCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.StorageTransaction.class 
		  			},
 					new Object[]{
				 		storageTransaction
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostStorageTransactionCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.StorageTransaction commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getStorageTransactionsWithinTimePeriod(
 			java.lang.String type
 		 			, java.lang.String status
 		 			, gov.va.med.imaging.exchange.business.TimePeriod period
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetStorageTransactionsWithinTimePeriodCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.business.TimePeriod.class 
		  			},
 					new Object[]{
				 		type,status,period
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStorageTransactionsWithinTimePeriodCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.TransferStatistics postTransferStatistics(
 			gov.va.med.imaging.exchange.business.storage.TransferStatistics transferStatistics
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.TransferStatistics> command = (Command<gov.va.med.imaging.exchange.business.storage.TransferStatistics>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.TransferStatistics.class, 
	 				"PostTransferStatisticsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.TransferStatistics.class 
		  			},
 					new Object[]{
				 		transferStatistics
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostTransferStatisticsCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.TransferStatistics commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean deleteProviderAvailability(
 			java.lang.Integer providerAvailabilityId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"DeleteProviderAvailabilityCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.Integer.class 
		  			},
 					new Object[]{
				 		providerAvailabilityId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("DeleteProviderAvailabilityCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean deleteRetentionPolicyProviderMapping(
 			java.lang.Integer mappingId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"DeleteRetentionPolicyProviderMappingCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.Integer.class 
		  			},
 					new Object[]{
				 		mappingId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("DeleteRetentionPolicyProviderMappingCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Artifact getArtifactAndInstancesById(
 			java.lang.Integer artifactId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Artifact> command = (Command<gov.va.med.imaging.exchange.business.storage.Artifact>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAndInstancesByIdCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.Integer.class 
		  			},
 					new Object[]{
				 		artifactId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetArtifactAndInstancesByIdCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Artifact commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Artifact getArtifactAndInstancesByKeyList(
 			gov.va.med.imaging.exchange.business.storage.KeyList keyList
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Artifact> command = (Command<gov.va.med.imaging.exchange.business.storage.Artifact>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAndInstancesByKeyListCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.KeyList.class 
		  			},
 					new Object[]{
				 		keyList
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetArtifactAndInstancesByKeyListCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Artifact commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Artifact getArtifactAndInstancesByToken(
 			java.lang.String artifactToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Artifact> command = (Command<gov.va.med.imaging.exchange.business.storage.Artifact>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAndInstancesByTokenCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetArtifactAndInstancesByTokenCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Artifact commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Artifact getArtifactAsGraphById(
 			java.lang.String artifactId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Artifact> command = (Command<gov.va.med.imaging.exchange.business.storage.Artifact>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAsGraphByIdCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetArtifactAsGraphByIdCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Artifact commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Artifact getArtifactAsGraphByToken(
 			java.lang.String artifactToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Artifact> command = (Command<gov.va.med.imaging.exchange.business.storage.Artifact>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactAsGraphByTokenCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetArtifactAsGraphByTokenCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Artifact commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Artifact getArtifactByToken(
 			java.lang.String artifactToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Artifact> command = (Command<gov.va.med.imaging.exchange.business.storage.Artifact>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"GetArtifactByTokenCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetArtifactByTokenCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Artifact commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo getCurrentWriteLocation(
 			gov.va.med.imaging.exchange.business.storage.Provider provider
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo> command = (Command<gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo.class, 
	 				"GetCurrentWriteLocationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Provider.class 
		  			},
 					new Object[]{
				 		provider
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetCurrentWriteLocationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo getCurrentJukeboxWriteLocation(
 			gov.va.med.imaging.exchange.business.storage.Provider provider
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo> command = (Command<gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo.class, 
	 				"GetCurrentJukeboxWriteLocationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Provider.class 
		  			},
 					new Object[]{
				 		provider
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetCurrentJukeboxWriteLocationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo getNetworkLocationDetails(
 			java.lang.String networkLocationIEN
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo> command = (Command<gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo.class, 
	 				"GetNetworkLocationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		networkLocationIEN
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetNetworkLocationDetailsCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.NetworkLocationInfo commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.StorageServerDatabaseConfiguration getStorageServerDatabaseConfiguration(
 			gov.va.med.imaging.exchange.business.storage.ProviderFactory providerFactory
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.StorageServerDatabaseConfiguration> command = (Command<gov.va.med.imaging.exchange.business.storage.StorageServerDatabaseConfiguration>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.StorageServerDatabaseConfiguration.class, 
	 				"GetStorageServerDatabaseConfigurationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ProviderFactory.class 
		  			},
 					new Object[]{
				 		providerFactory
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStorageServerDatabaseConfigurationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.StorageServerDatabaseConfiguration commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Artifact putArtifact(
 			gov.va.med.imaging.exchange.business.storage.Artifact artifact
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Artifact> command = (Command<gov.va.med.imaging.exchange.business.storage.Artifact>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Artifact.class, 
	 				"PutArtifactCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Artifact.class 
		  			},
 					new Object[]{
				 		artifact
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PutArtifactCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Artifact commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.ArtifactInstance putArtifactInstanceLastAccessed(
 			gov.va.med.imaging.exchange.business.storage.ArtifactInstance artifactInstance
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.ArtifactInstance> command = (Command<gov.va.med.imaging.exchange.business.storage.ArtifactInstance>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class, 
	 				"PutArtifactInstanceLastAccessedCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class 
		  			},
 					new Object[]{
				 		artifactInstance
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PutArtifactInstanceLastAccessedCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.ArtifactInstance commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.ArtifactInstance putArtifactInstanceUrl(
 			gov.va.med.imaging.exchange.business.storage.ArtifactInstance artifactInstance
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.ArtifactInstance> command = (Command<gov.va.med.imaging.exchange.business.storage.ArtifactInstance>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class, 
	 				"PutArtifactInstanceUrlCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactInstance.class 
		  			},
 					new Object[]{
				 		artifactInstance
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PutArtifactInstanceUrlCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.ArtifactInstance commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy putArtifactRetentionPolicy(
 			gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy artifactRetentionPolicy
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy> command = (Command<gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy.class, 
	 				"PutArtifactRetentionPolicyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy.class 
		  			},
 					new Object[]{
				 		artifactRetentionPolicy
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PutArtifactRetentionPolicyCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.ArtifactRetentionPolicy commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.ProviderAvailability putProviderAvailability(
 			gov.va.med.imaging.exchange.business.storage.ProviderAvailability providerAvailability
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.ProviderAvailability> command = (Command<gov.va.med.imaging.exchange.business.storage.ProviderAvailability>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.ProviderAvailability.class, 
	 				"PutProviderAvailabilityCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ProviderAvailability.class 
		  			},
 					new Object[]{
				 		providerAvailability
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PutProviderAvailabilityCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.ProviderAvailability commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.Provider putProvider(
 			gov.va.med.imaging.exchange.business.storage.Provider provider
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.Provider> command = (Command<gov.va.med.imaging.exchange.business.storage.Provider>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.Provider.class, 
	 				"PutProviderCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.Provider.class 
		  			},
 					new Object[]{
				 		provider
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PutProviderCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.Provider commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.RetentionPolicy putRetentionPolicy(
 			gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor artifactDescriptor
 		 			, gov.va.med.imaging.exchange.business.storage.RetentionPolicy retentionPolicy
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.RetentionPolicy> command = (Command<gov.va.med.imaging.exchange.business.storage.RetentionPolicy>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.RetentionPolicy.class, 
	 				"PutRetentionPolicyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor.class, gov.va.med.imaging.exchange.business.storage.RetentionPolicy.class 
		  			},
 					new Object[]{
				 		artifactDescriptor,retentionPolicy
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PutRetentionPolicyCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.RetentionPolicy commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping putRetentionPolicyProviderMapping(
 			gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping mapping
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping> command = (Command<gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping.class, 
	 				"PutRetentionPolicyProviderMappingCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping.class 
		  			},
 					new Object[]{
				 		mapping
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PutRetentionPolicyProviderMappingCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.storage.RetentionPolicyProviderMapping commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 }