/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.core.router.storage;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class StorageBusinessRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public StorageBusinessRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getArtifactStream(
 			java.lang.String artifactToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetArtifactStreamCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.io.InputStream.class, 
	 				"GetArtifactStreamCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetArtifactStreamCommand' in method 'getArtifactStream' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getResolvedArtifactStream(
 			gov.va.med.imaging.exchange.business.storage.ArtifactSourceInfo sourceInfo
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetResolvedArtifactStreamCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactSourceInfo'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.io.InputStream.class, 
	 				"GetResolvedArtifactStreamCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactSourceInfo.class 
		  			},
 					new Object[]{
				 		sourceInfo
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetResolvedArtifactStreamCommand' in method 'getResolvedArtifactStream' with parameters 'gov.va.med.imaging.exchange.business.storage.ArtifactSourceInfo'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postArtifactByStream(
 			java.io.InputStream artifactStream
 		 			, java.nio.channels.ReadableByteChannel artifactChannel
 		 			, gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor artifactDescriptor
 		 			, java.lang.String place
 		 			, gov.va.med.imaging.exchange.business.storage.KeyList keyList
 		 			, java.lang.String createdBy
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostArtifactByStreamCommand' and parameters 'java.io.InputStream, java.nio.channels.ReadableByteChannel, gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor, java.lang.String, gov.va.med.imaging.exchange.business.storage.KeyList, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"PostArtifactByStreamCommand",
	 				"",
 					new Class<?>[]{
				 		 java.io.InputStream.class, java.nio.channels.ReadableByteChannel.class, gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor.class, java.lang.String.class, gov.va.med.imaging.exchange.business.storage.KeyList.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactStream,artifactChannel,artifactDescriptor,place,keyList,createdBy
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostArtifactByStreamCommand' in method 'postArtifactByStream' with parameters 'java.io.InputStream, java.nio.channels.ReadableByteChannel, gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor, java.lang.String, gov.va.med.imaging.exchange.business.storage.KeyList, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processAsyncStorageRequest(
 			gov.va.med.imaging.exchange.business.storage.AsyncStorageRequest request
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessAsyncStorageRequestCommand' and parameters 'gov.va.med.imaging.exchange.business.storage.AsyncStorageRequest'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"ProcessAsyncStorageRequestCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.AsyncStorageRequest.class 
		  			},
 					new Object[]{
				 		request
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessAsyncStorageRequestCommand' in method 'processAsyncStorageRequest' with parameters 'gov.va.med.imaging.exchange.business.storage.AsyncStorageRequest'.");
 		}

 }