/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.core.router.storage;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class StorageBusinessRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements StorageBusinessRouter
 {
	private static StorageBusinessRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized StorageBusinessRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new StorageBusinessRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected StorageBusinessRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.io.InputStream getArtifactStream(
 			java.lang.String artifactToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.io.InputStream> command = (Command<java.io.InputStream>)getCommandFactory().createCommand(
	 				 java.io.InputStream.class, 
	 				"GetArtifactStreamCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetArtifactStreamCommand");
		
      
        java.io.InputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.io.InputStream getResolvedArtifactStream(
 			gov.va.med.imaging.exchange.business.storage.ArtifactSourceInfo sourceInfo
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.io.InputStream> command = (Command<java.io.InputStream>)getCommandFactory().createCommand(
	 				 java.io.InputStream.class, 
	 				"GetResolvedArtifactStreamCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.ArtifactSourceInfo.class 
		  			},
 					new Object[]{
				 		sourceInfo
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetResolvedArtifactStreamCommand");
		
      
        java.io.InputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String postArtifactByStream(
 			java.io.InputStream artifactStream
 		 			, java.nio.channels.ReadableByteChannel artifactChannel
 		 			, gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor artifactDescriptor
 		 			, java.lang.String place
 		 			, gov.va.med.imaging.exchange.business.storage.KeyList keyList
 		 			, java.lang.String createdBy
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"PostArtifactByStreamCommand",
	 				"",
 					new Class<?>[]{
				 		 java.io.InputStream.class, java.nio.channels.ReadableByteChannel.class, gov.va.med.imaging.exchange.business.storage.ArtifactDescriptor.class, java.lang.String.class, gov.va.med.imaging.exchange.business.storage.KeyList.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		artifactStream,artifactChannel,artifactDescriptor,place,keyList,createdBy
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostArtifactByStreamCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean processAsyncStorageRequest(
 			gov.va.med.imaging.exchange.business.storage.AsyncStorageRequest request
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"ProcessAsyncStorageRequestCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.storage.AsyncStorageRequest.class 
		  			},
 					new Object[]{
				 		request
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessAsyncStorageRequestCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 }