/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author     DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.core.router.facade;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class InternalRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public InternalRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTreatingSites(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetTreatingSitesCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.artifactsource.ResolvedArtifactSource.class, 
 				"GetTreatingSitesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetTreatingSitesCommand' in method 'getTreatingSites' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTreatingSitesFromDataSource(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, boolean includeTrailingCharactersForSite200
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetTreatingSitesFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, boolean'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetTreatingSitesFromDataSourceCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, boolean.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,includeTrailingCharactersForSite200
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetTreatingSitesFromDataSourceCommand' in method 'getTreatingSitesFromDataSource' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getResolvedArtifactSource(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetResolvedArtifactSourceCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.artifactsource.ResolvedArtifactSource.class, 
 				"GetResolvedArtifactSourceCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetResolvedArtifactSourceCommand' in method 'getResolvedArtifactSource' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void dequeueDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DequeueDurableQueueMessageCommand' and parameters 'gov.va.med.RoutingToken, int'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
	 				"DequeueDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,queueId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DequeueDurableQueueMessageCommand' in method 'dequeueDurableQueueMessage' with parameters 'gov.va.med.RoutingToken, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void dequeueDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, java.lang.String messageGroupId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DequeueDurableQueueMessageCommand' and parameters 'gov.va.med.RoutingToken, int, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
	 				"DequeueDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,queueId,messageGroupId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DequeueDurableQueueMessageCommand' in method 'dequeueDurableQueueMessage' with parameters 'gov.va.med.RoutingToken, int, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void enqueueDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DurableQueueMessage message
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'EnqueueDurableQueueMessageCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DurableQueueMessage'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"EnqueueDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DurableQueueMessage.class 
		  			},
 					new Object[]{
				 		routingToken,message
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'EnqueueDurableQueueMessageCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDurableQueueMessageCommand' and parameters 'gov.va.med.RoutingToken, int'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
	 				"GetDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,queueId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDurableQueueMessageCommand' in method 'getDurableQueueMessage' with parameters 'gov.va.med.RoutingToken, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, java.lang.String messageGroupId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDurableQueueMessageCommand' and parameters 'gov.va.med.RoutingToken, int, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
	 				"GetDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,queueId,messageGroupId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDurableQueueMessageCommand' in method 'getDurableQueueMessage' with parameters 'gov.va.med.RoutingToken, int, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDurableQueueMessageCount(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDurableQueueMessageCountCommand' and parameters 'gov.va.med.RoutingToken, int'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetDurableQueueMessageCountCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,queueId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDurableQueueMessageCountCommand' in method 'getDurableQueueMessageCount' with parameters 'gov.va.med.RoutingToken, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDurableQueueMessageCount(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, java.lang.String messageGroupId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDurableQueueMessageCountCommand' and parameters 'gov.va.med.RoutingToken, int, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetDurableQueueMessageCountCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,queueId,messageGroupId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDurableQueueMessageCountCommand' in method 'getDurableQueueMessageCount' with parameters 'gov.va.med.RoutingToken, int, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDurableQueueMessages(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, int startIndex
 		 			, int numRecords
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDurableQueueMessagesCommand' and parameters 'gov.va.med.RoutingToken, int, int, int'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
 				"GetDurableQueueMessagesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, int.class, int.class, int.class 
	  			},
				new Object[]{
			 		routingToken,queueId,startIndex,numRecords
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetDurableQueueMessagesCommand' in method 'getDurableQueueMessages' with parameters 'gov.va.med.RoutingToken, int, int, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDurableQueueMessages(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, java.lang.String messageGroupId
 		 			, int startIndex
 		 			, int numRecords
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDurableQueueMessagesCommand' and parameters 'gov.va.med.RoutingToken, int, java.lang.String, int, int'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
 				"GetDurableQueueMessagesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, int.class, java.lang.String.class, int.class, int.class 
	  			},
				new Object[]{
			 		routingToken,queueId,messageGroupId,startIndex,numRecords
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetDurableQueueMessagesCommand' in method 'getDurableQueueMessages' with parameters 'gov.va.med.RoutingToken, int, java.lang.String, int, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getAllDurableQueues(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetAllDurableQueuesCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.DurableQueue.class, 
 				"GetAllDurableQueuesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetAllDurableQueuesCommand' in method 'getAllDurableQueues' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDurableQueueByName(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String queueName
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDurableQueueByNameCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.DurableQueue.class, 
	 				"GetDurableQueueByNameCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,queueName
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDurableQueueByNameCommand' in method 'getDurableQueueByName' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postMoveDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int messageId
 		 			, int targetQueueId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostMoveDurableQueueMessageCommand' and parameters 'gov.va.med.RoutingToken, int, int'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostMoveDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,messageId,targetQueueId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostMoveDurableQueueMessageCommand' in method 'postMoveDurableQueueMessage' with parameters 'gov.va.med.RoutingToken, int, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postMoveAllDurableQueueMessages(
 			gov.va.med.RoutingToken routingToken
 		 			, int sourceQueueId
 		 			, int targetQueueId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostMoveAllDurableQueueMessagesCommand' and parameters 'gov.va.med.RoutingToken, int, int'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostMoveAllDurableQueueMessagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,sourceQueueId,targetQueueId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostMoveAllDurableQueueMessagesCommand' in method 'postMoveAllDurableQueueMessages' with parameters 'gov.va.med.RoutingToken, int, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postMoveAllDurableQueueMessages(
 			gov.va.med.RoutingToken routingToken
 		 			, int sourceQueueId
 		 			, int targetQueueId
 		 			, java.lang.String messageGroupId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostMoveAllDurableQueueMessagesCommand' and parameters 'gov.va.med.RoutingToken, int, int, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostMoveAllDurableQueueMessagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, int.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,sourceQueueId,targetQueueId,messageGroupId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostMoveAllDurableQueueMessagesCommand' in method 'postMoveAllDurableQueueMessages' with parameters 'gov.va.med.RoutingToken, int, int, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDurableQueue(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DurableQueue queue
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostDurableQueueCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DurableQueue'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostDurableQueueCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DurableQueue.class 
		  			},
 					new Object[]{
				 		routingToken,queue
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostDurableQueueCommand' in method 'postDurableQueue' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DurableQueue'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.ServiceRegistration registration
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostServiceRegistrationCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.ServiceRegistration'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.ServiceRegistration.class 
		  			},
 					new Object[]{
				 		routingToken,registration
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostServiceRegistrationCommand' in method 'postServiceRegistration' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.ServiceRegistration'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void putServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.ServiceRegistration registration
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PutServiceRegistrationCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.ServiceRegistration'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ServiceRegistration.class, 
	 				"PutServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.ServiceRegistration.class 
		  			},
 					new Object[]{
				 		routingToken,registration
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PutServiceRegistrationCommand' in method 'putServiceRegistration' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.ServiceRegistration'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.ServiceRegistration registration
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DeleteServiceRegistrationCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.ServiceRegistration'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"DeleteServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.ServiceRegistration.class 
		  			},
 					new Object[]{
				 		routingToken,registration
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DeleteServiceRegistrationCommand' in method 'deleteServiceRegistration' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.ServiceRegistration'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, int id
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetServiceRegistrationCommand' and parameters 'gov.va.med.RoutingToken, int'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ServiceRegistration.class, 
	 				"GetServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,id
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetServiceRegistrationCommand' in method 'getServiceRegistration' with parameters 'gov.va.med.RoutingToken, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getServiceRegistrationByServiceId(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String serviceId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetServiceRegistrationByServiceIdCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.ServiceRegistration.class, 
 				"GetServiceRegistrationByServiceIdCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,serviceId
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetServiceRegistrationByServiceIdCommand' in method 'getServiceRegistrationByServiceId' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.ServiceRegistration serviceRegistration
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessServiceRegistrationCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.ServiceRegistration'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"ProcessServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.ServiceRegistration.class 
		  			},
 					new Object[]{
				 		routingToken,serviceRegistration
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessServiceRegistrationCommand' in method 'processServiceRegistration' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.ServiceRegistration'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getAllErrorTypeNotificationConfiguration(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetAllErrorTypeNotificationConfigurationCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration.class, 
 				"GetAllErrorTypeNotificationConfigurationCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetAllErrorTypeNotificationConfigurationCommand' in method 'getAllErrorTypeNotificationConfiguration' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getErrorTypeNotificationConfiguration(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String errorType
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetErrorTypeNotificationConfigurationCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration.class, 
	 				"GetErrorTypeNotificationConfigurationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,errorType
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetErrorTypeNotificationConfigurationCommand' in method 'getErrorTypeNotificationConfiguration' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postErrorTypeNotificationConfiguration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration config
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostErrorTypeNotificationConfigurationCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostErrorTypeNotificationConfigurationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration.class 
		  			},
 					new Object[]{
				 		routingToken,config
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostErrorTypeNotificationConfigurationCommand' in method 'postErrorTypeNotificationConfiguration' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processSiteServiceCacheRefresh(
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'ProcessSiteServiceCacheRefreshAsyncCommand' and parameters ''.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"ProcessSiteServiceCacheRefreshAsyncCommand",
	 			"",
				new Class<?>[]{
				 	 
		  		},
				new Object[]{
			 		
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'ProcessSiteServiceCacheRefreshAsyncCommand' in method 'processSiteServiceCacheRefresh' with parameters ''.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postAuditEvent(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.AuditEvent auditEvent
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostAuditEventCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.AuditEvent'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostAuditEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.AuditEvent.class 
		  			},
 					new Object[]{
				 		routingToken,auditEvent
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostAuditEventCommand' in method 'postAuditEvent' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.AuditEvent'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getUserKeys(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetUserKeysCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetUserKeysCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetUserKeysCommand' in method 'getUserKeys' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientsByName(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String searchName
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientSetByNameFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.Set.class, 
 				 gov.va.med.imaging.exchange.business.Patient.class, 
 				"GetPatientSetByNameFromDataSourceCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,searchName
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPatientSetByNameFromDataSourceCommand' in method 'getPatientsByName' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getWelcomeMessageFromSite(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetWelcomeMessageBySiteCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.WelcomeMessage.class, 
	 				"GetWelcomeMessageBySiteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetWelcomeMessageBySiteCommand' in method 'getWelcomeMessageFromSite' with parameters 'gov.va.med.RoutingToken'.");
 		}

 }