/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.core.router.facade;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class InternalRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements InternalRouter
 {
	private static InternalRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized InternalRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new InternalRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected InternalRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.artifactsource.ResolvedArtifactSource> getTreatingSites(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.artifactsource.ResolvedArtifactSource.class, 
 				"GetTreatingSitesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetTreatingSitesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<gov.va.med.imaging.artifactsource.ResolvedArtifactSource> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<java.lang.String> getTreatingSitesFromDataSource(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, boolean includeTrailingCharactersForSite200
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetTreatingSitesFromDataSourceCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, boolean.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,includeTrailingCharactersForSite200
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetTreatingSitesFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<java.lang.String> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.artifactsource.ResolvedArtifactSource> getResolvedArtifactSource(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.artifactsource.ResolvedArtifactSource.class, 
 				"GetResolvedArtifactSourceCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetResolvedArtifactSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<gov.va.med.imaging.artifactsource.ResolvedArtifactSource> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.DurableQueueMessage dequeueDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.DurableQueueMessage> command = (Command<gov.va.med.imaging.exchange.business.DurableQueueMessage>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
	 				"DequeueDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,queueId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("DequeueDurableQueueMessageCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.DurableQueueMessage commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.DurableQueueMessage dequeueDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, java.lang.String messageGroupId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.DurableQueueMessage> command = (Command<gov.va.med.imaging.exchange.business.DurableQueueMessage>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
	 				"DequeueDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,queueId,messageGroupId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("DequeueDurableQueueMessageCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.DurableQueueMessage commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void enqueueDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DurableQueueMessage message
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"EnqueueDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DurableQueueMessage.class 
		  			},
 					new Object[]{
				 		routingToken,message
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("EnqueueDurableQueueMessageCommand");
		
		      			command.setChildCommand(true);
      					command.setParentCommandIdString(transactionContext.getCommandId());		      			
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.DurableQueueMessage getDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.DurableQueueMessage> command = (Command<gov.va.med.imaging.exchange.business.DurableQueueMessage>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
	 				"GetDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,queueId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDurableQueueMessageCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.DurableQueueMessage commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.DurableQueueMessage getDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, java.lang.String messageGroupId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.DurableQueueMessage> command = (Command<gov.va.med.imaging.exchange.business.DurableQueueMessage>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
	 				"GetDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,queueId,messageGroupId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDurableQueueMessageCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.DurableQueueMessage commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getDurableQueueMessageCount(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetDurableQueueMessageCountCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,queueId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDurableQueueMessageCountCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getDurableQueueMessageCount(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, java.lang.String messageGroupId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetDurableQueueMessageCountCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,queueId,messageGroupId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDurableQueueMessageCountCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.DurableQueueMessage> getDurableQueueMessages(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, int startIndex
 		 			, int numRecords
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
 				"GetDurableQueueMessagesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, int.class, int.class, int.class 
	  			},
				new Object[]{
			 		routingToken,queueId,startIndex,numRecords
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDurableQueueMessagesCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.DurableQueueMessage> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.DurableQueueMessage> getDurableQueueMessages(
 			gov.va.med.RoutingToken routingToken
 		 			, int queueId
 		 			, java.lang.String messageGroupId
 		 			, int startIndex
 		 			, int numRecords
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.DurableQueueMessage.class, 
 				"GetDurableQueueMessagesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, int.class, java.lang.String.class, int.class, int.class 
	  			},
				new Object[]{
			 		routingToken,queueId,messageGroupId,startIndex,numRecords
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDurableQueueMessagesCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.DurableQueueMessage> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.DurableQueue> getAllDurableQueues(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.DurableQueue.class, 
 				"GetAllDurableQueuesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetAllDurableQueuesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<gov.va.med.imaging.exchange.business.DurableQueue> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.DurableQueue getDurableQueueByName(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String queueName
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.DurableQueue> command = (Command<gov.va.med.imaging.exchange.business.DurableQueue>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.DurableQueue.class, 
	 				"GetDurableQueueByNameCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,queueName
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDurableQueueByNameCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.DurableQueue commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postMoveDurableQueueMessage(
 			gov.va.med.RoutingToken routingToken
 		 			, int messageId
 		 			, int targetQueueId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostMoveDurableQueueMessageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,messageId,targetQueueId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostMoveDurableQueueMessageCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postMoveAllDurableQueueMessages(
 			gov.va.med.RoutingToken routingToken
 		 			, int sourceQueueId
 		 			, int targetQueueId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostMoveAllDurableQueueMessagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,sourceQueueId,targetQueueId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostMoveAllDurableQueueMessagesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postMoveAllDurableQueueMessages(
 			gov.va.med.RoutingToken routingToken
 		 			, int sourceQueueId
 		 			, int targetQueueId
 		 			, java.lang.String messageGroupId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostMoveAllDurableQueueMessagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class, int.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,sourceQueueId,targetQueueId,messageGroupId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostMoveAllDurableQueueMessagesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postDurableQueue(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DurableQueue queue
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostDurableQueueCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DurableQueue.class 
		  			},
 					new Object[]{
				 		routingToken,queue
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostDurableQueueCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.ServiceRegistration registration
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.ServiceRegistration.class 
		  			},
 					new Object[]{
				 		routingToken,registration
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostServiceRegistrationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ServiceRegistration putServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.ServiceRegistration registration
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ServiceRegistration> command = (Command<gov.va.med.imaging.exchange.business.ServiceRegistration>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ServiceRegistration.class, 
	 				"PutServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.ServiceRegistration.class 
		  			},
 					new Object[]{
				 		routingToken,registration
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PutServiceRegistrationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ServiceRegistration commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean deleteServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.ServiceRegistration registration
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"DeleteServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.ServiceRegistration.class 
		  			},
 					new Object[]{
				 		routingToken,registration
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("DeleteServiceRegistrationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ServiceRegistration getServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, int id
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ServiceRegistration> command = (Command<gov.va.med.imaging.exchange.business.ServiceRegistration>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ServiceRegistration.class, 
	 				"GetServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,id
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetServiceRegistrationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ServiceRegistration commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.ServiceRegistration> getServiceRegistrationByServiceId(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String serviceId
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.ServiceRegistration.class, 
 				"GetServiceRegistrationByServiceIdCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,serviceId
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetServiceRegistrationByServiceIdCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<gov.va.med.imaging.exchange.business.ServiceRegistration> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean processServiceRegistration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.ServiceRegistration serviceRegistration
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"ProcessServiceRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.ServiceRegistration.class 
		  			},
 					new Object[]{
				 		routingToken,serviceRegistration
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessServiceRegistrationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration> getAllErrorTypeNotificationConfiguration(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration.class, 
 				"GetAllErrorTypeNotificationConfigurationCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetAllErrorTypeNotificationConfigurationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration getErrorTypeNotificationConfiguration(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String errorType
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration> command = (Command<gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration.class, 
	 				"GetErrorTypeNotificationConfigurationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,errorType
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetErrorTypeNotificationConfigurationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postErrorTypeNotificationConfiguration(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration config
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostErrorTypeNotificationConfigurationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.veins.ErrorTypeNotificationConfiguration.class 
		  			},
 					new Object[]{
				 		routingToken,config
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostErrorTypeNotificationConfigurationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processSiteServiceCacheRefresh(
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"ProcessSiteServiceCacheRefreshAsyncCommand",
	 			"",
				new Class<?>[]{
				 	 
		  		},
				new Object[]{
			 		
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postAuditEvent(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.AuditEvent auditEvent
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostAuditEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.AuditEvent.class 
		  			},
 					new Object[]{
				 		routingToken,auditEvent
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostAuditEventCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<java.lang.String> getUserKeys(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetUserKeysCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetUserKeysCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<java.lang.String> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.Set<gov.va.med.imaging.exchange.business.Patient> getPatientsByName(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String searchName
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.Set> command = getCommandFactory().createCollectionCommand(
 				 java.util.Set.class, 
 				 gov.va.med.imaging.exchange.business.Patient.class, 
 				"GetPatientSetByNameFromDataSourceCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,searchName
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPatientSetByNameFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.Set<gov.va.med.imaging.exchange.business.Patient> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.WelcomeMessage getWelcomeMessageFromSite(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.WelcomeMessage> command = (Command<gov.va.med.imaging.exchange.business.WelcomeMessage>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.WelcomeMessage.class, 
	 				"GetWelcomeMessageBySiteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetWelcomeMessageBySiteCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.WelcomeMessage commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 }