/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 20, 2008
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:       DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.clinicaldisplay.webservices;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.ImageURN;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.clinicaldisplay.ClinicalDisplayRouter;
import gov.va.med.imaging.clinicaldisplay.ImagingClinicalDisplayContext;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.FatImageType;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.FilterType;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ImageAccessLogEventType;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ImageClinicalDisplayMetadata;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.PingServerTypeResponse;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ShallowStudyType;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.UserCredentials;
import gov.va.med.imaging.clinicaldisplay.webservices.translator.ClinicalDisplayTranslator2;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.ImageNotFoundException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.business.ArtifactResults;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.business.Requestor.PurposeOfUse;
import gov.va.med.imaging.exchange.business.util.ExchangeUtil;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.rmi.RemoteException;

import org.apache.log4j.Logger;

/**
 * @author      DNS
 *
 */
public class ClinicalDisplayWebservices_v2 implements
		ImageClinicalDisplayMetadata {
	
	private final static Logger logger = Logger.getLogger(ClinicalDisplayWebservices_v2.class);
	private final static ClinicalDisplayTranslator2 interpreter = new ClinicalDisplayTranslator2();

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ImageClinicalDisplayMetadata#getPatientShallowStudyList(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.FilterType, gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.UserCredentials)
	 */
	@Override
	public ShallowStudyType[] getPatientShallowStudyList(String transactionId,
			String siteId, String patientId, FilterType filter,
			UserCredentials credentials) throws RemoteException {
		setTransactionContext(credentials, transactionId);
		Long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getPatientShallowStudyList transaction(" + transactionId + ")" );
		TransactionContext transactionContext = TransactionContextFactory.get();
		StudyFilter internalFilter = interpreter.transformFilter(filter);
		// initialize the transaction context
		//TODO: set Request type generically
		transactionContext.setRequestType(getWepAppName() + " getPatientShallowStudyList");
		transactionContext.setPatientID(patientId);
		transactionContext.setQueryFilter(TransactionContextFactory.getFilterDateRange(internalFilter.getFromDate(), internalFilter.getToDate()));
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		if(ExchangeUtil.isSiteDOD(credentials.getSiteNumber()))
		{
			transactionContext.setRequestingSource("DOD");
		}
		else
		{
			transactionContext.setRequestingSource("VA");
		}
		
		// get the message context first
        //MessageContext msgContext = MessageContext.getCurrentContext();
        //HttpServletRequest request = (HttpServletRequest) msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
       		
		logger.debug("getPatientShallowStudyList transforming filter into business object.");
		
		ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
		//Router router = ImagingClinicalDisplayContext.getVixRouter();

		logger.debug("getPatientShallowStudyList getting patient studies list from " + rtr.getClass().getName() + 
				" type manager instance.");
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ShallowStudyType[] result = null;
		
		try 	
		{			
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			logger.info("Routing getPatientShallowStudyList to site '" + routingToken.toRoutingTokenString() + "'.");
			// must call patient artifact command in order to get all studies if calling a VA site with patch 104 installed (since study graph SPI now only returns radiology data)
			ArtifactResults artifactResults = rtr.getStudyWithReportArtifactResultsForPatientFromSite(
					routingToken, 
					PatientIdentifier.icnPatientIdentifier(patientId),
					internalFilter, true, false);
			
			// update the transaction context with the study count
			transactionContext.setEntriesReturned( artifactResults == null ? 0 : artifactResults.getArtifactSize() );
			logger.debug("getPatientShallowStudyList transforming results from business objects.");
			result = interpreter.transformStudiesToShallowStudies(artifactResults);
		}
		catch(MethodException mX)
		{
			logger.error("FAILED getPatientShallowStudyList method Exception: " + mX.toString() + " ms", mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", mX);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED getPatientShallowStudyList connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(URNFormatException iurnfX)
		{
			logger.error("FAILED getPatientShallowStudyList transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", iurnfX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			logger.error("FAILED getPatientShallowStudyList transaction(" + transactionId, rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", rtfX);
		}

		if( logger.isDebugEnabled() )
		{
			StringBuilder sb = new StringBuilder();
			
			sb.append("getPatientShallowStudyList returning " + (result == null ? "<null>" : result.length) + " study IDs: \n");
			for(int studyIndex = 0; result != null && studyIndex < result.length; ++studyIndex)
			{
				sb.append("  - " + result[studyIndex].getStudyId());
				if( result[studyIndex].getFirstImage() != null )
					sb.append(" - " + result[studyIndex].getFirstImage().getImageId());
				sb.append(" \n");
			}
			logger.debug(sb.toString());
		}
		
		logger.info("complete ClinicalDisplay getPatientShallowStudyList transaction(" + transactionId + ") in " + 
				(System.currentTimeMillis() - startTime) + 	" ms)" );
        return result;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ImageClinicalDisplayMetadata#getStudyImageList(java.lang.String, java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.UserCredentials)
	 */
	@Override
	public FatImageType[] getStudyImageList(
		String transactionId,
		String studyId, 
		UserCredentials credentials) 
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
    	
    	long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getStudyImageList transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		StudyURN studyUrn = null;
		String patientIdentifier = null;
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.FatImageType[] result = null;
		// initialize the transaction context
		//TODO: set Request type generically
		
		if(ExchangeUtil.isSiteDOD(credentials.getSiteNumber()))
		{
			transactionContext.setRequestingSource("DOD");
		}
		else
		{
			transactionContext.setRequestingSource("VA");
		}
		
		transactionContext.setRequestType(getWepAppName() + " getStudyImageList");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		
		try 
		{
			studyUrn = URNFactory.create(studyId, SERIALIZATION_FORMAT.CDTP, StudyURN.class);
			patientIdentifier = studyUrn.getPatientId();
			
			transactionContext.setUrn(studyUrn.toString());
			// update the transaction context with patientId
			transactionContext.setPatientID(patientIdentifier);
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			
			Study study = rtr.getPatientStudy( (StudyURN)studyUrn );
			
			transactionContext.setEntriesReturned( study == null ? 0 : study.getImageCount());
			result = interpreter.transformStudyToFatImages(study);
			/*
			images = vixCore.getStudyImageList(studyUrn);
			// update the transaction context with the image count
			transactionContext.setEntriesReturned( images == null ? 0 : images.size() );
			result = (gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.FatImageType[])interpreter.transformImagesToFatImages(images);
			*/
		}
		catch(URNFormatException iurnfX) {
			logger.info("FAILED getStudyImageList transaction(" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable " + ((studyUrn==null) ? "to translate study Id" : "to transform Images"), iurnfX);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED getPatientShallowStudyList connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(MethodException mX) {
			logger.info("FAILED getStudyImageList method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study images", mX);
		}
		logger.info("complete ClinicalDisplay getStudyImageList transaction(" + transactionId + ") in " + 
				(System.currentTimeMillis() - startTime) + 	" ms" );
		return result;   
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ImageClinicalDisplayMetadata#pingServerEvent(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.UserCredentials)
	 */
	@Override
	public PingServerTypeResponse pingServerEvent(String transactionId,
			String clientWorkstation, String requestSiteNumber, UserCredentials credentials) 
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		logger.info("pingServerEvent from [" + clientWorkstation + "] going to site number [" + requestSiteNumber + "]");
    	
		PingServerTypeResponse response = PingServerTypeResponse.SERVER_UNAVAILABLE;
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " pingServer to (" + requestSiteNumber + ")");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		transactionContext.setRequestingSource(credentials.getSiteNumber());
		
		// JMW 9/8/2008 - version 2 of the interface is now only for viewing DOD images for patch 72
		// Use version 3 for viewing VA images through Federation (Clin Display Patch 93)
		if(ExchangeUtil.isSiteDOD(requestSiteNumber))
		{
			response = PingServerTypeResponse.SERVER_READY;
		}
		/*
		Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
		
		SiteConnectivityStatus siteStatus = vixCore.isSiteAvailable(requestSiteNumber);			
		response = interpreter.transformServerStatusToPingServerResponse(siteStatus);
		*/
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ImageClinicalDisplayMetadata#postImageAccessEvent(java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ImageAccessLogEventType)
	 */
	@Override
	public boolean postImageAccessEvent(String transactionId,
			ImageAccessLogEventType logEvent) 
	throws RemoteException 
	{
		setTransactionContext(logEvent.getCredentials(), transactionId);
		TransactionContext transactionContext = TransactionContextFactory.get();
    	long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay postImageAccessEvent transaction(" + transactionId + ")" );
		logger.info("logEvent message [" + logEvent.getReason() + "]");
		try
		{	
			transactionContext.setRequestType(getWepAppName() + " postImageAccessEvent [" + logEvent.getEventType() + "]");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			// need to use the Id from the webservice log event since it is the full URN and not just 
			// the individual image identifier
			transactionContext.setUrn(logEvent.getImageId());
			ImageAccessLogEvent event = interpreter.transformLogEvent(logEvent);
			transactionContext.setPatientID(event.getPatientIcn());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			rtr.logImageAccessEvent(event);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED postImageAccessEvent connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to post image access", cX);
		}
		catch(MethodException cX)
		{
			logger.error("FAILED postImageAccessEvent method Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to post image access", cX);
		}
		catch(URNFormatException iurnfX) {
			logger.info("FAILED postImageAccessEvent transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		} 
		logger.info("complete ClinicalDisplay postImageAccessEvent transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return true;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.ImageClinicalDisplayMetadata#prefetchStudyList(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.FilterType, gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.UserCredentials)
	 */
	@Override
	public String prefetchStudyList(String transactionId, String siteId, String patientId, 
			FilterType filter, UserCredentials credentials)
	throws RemoteException 
	{
		// TODO Auto-generated method stub
		return null;
	}
	
	
	@Override
	public String getImageInformation(String imageId, String transactionId,
			UserCredentials credentials) 
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getImageInformation transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		ImageURN imageUrn = null;
		try{
			imageUrn = URNFactory.create(imageId, SERIALIZATION_FORMAT.CDTP, ImageURN.class);
			transactionContext.setPatientID(imageUrn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageInformation");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(imageUrn.toString());
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			String response = rtr.getImageInformation(imageUrn);
			logger.info("complete ClinicalDisplay getImageInformation transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch (ClassCastException e)
        {
			String msg = "'" + imageId + "' is not a valid image identifier (ImageURN).";
			logger.info(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(e.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", e);
        } 
		catch(URNFormatException iurnfX)
		{
			logger.info("FAIlED getImageInformation transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			logger.info("FAILED getImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", infX);
			transactionContext.setErrorMessage(infX.getMessage());
			transactionContext.setExceptionClassName(infX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image information", infX);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED getImageInformation connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED getImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image information", mX);
		}
	}

	@Override
	public String getStudyImageInformation(String studyId, String transactionId, 
			UserCredentials credentials)
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getStudyImageInformation transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		StudyURN studyUrn = null;
		try{
			studyUrn = URNFactory.create(studyId, SERIALIZATION_FORMAT.CDTP, StudyURN.class);
			transactionContext.setPatientID(studyUrn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageInformation");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(studyUrn.toString());
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			String response = rtr.getImageInformation(studyUrn);
			logger.info("complete ClinicalDisplay getStudyImageInformation transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch (ClassCastException e)
        {
			// the URN.create() can throw a ClassCastException if the string URN has the wrong namespace identifier
			String msg = "'" + studyId + "' is not a valid study identifier (StudyURN).";
			logger.info(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(e.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", e);
        } 
		catch(URNFormatException iurnfX)
		{
			logger.info("FAIlED getStudyImageInformation transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			logger.info("FAILED getStudyImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", infX);
			transactionContext.setErrorMessage(infX.getMessage());
			transactionContext.setExceptionClassName(infX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image information", infX);
		}
		catch(ConnectionException ioX)
		{
			logger.info("FAILED getStudyImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", ioX);
			transactionContext.setErrorMessage(ioX.getMessage());
			transactionContext.setExceptionClassName(ioX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image information", ioX);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED getStudyImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image information", mX);
		}
	}

	@Override
	public String getImageSystemGlobalNode(String imageId, String transactionId, 
		UserCredentials credentials)
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getImageSystemGlobalNode transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		ImageURN imageUrn = null;
		try{
			imageUrn = URNFactory.create(imageId, SERIALIZATION_FORMAT.CDTP, ImageURN.class);
			transactionContext.setPatientID(imageUrn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageSystemGlobalNode");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(imageUrn.toString());
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			String response = rtr.getImageSystemGlobalNode(imageUrn);
			logger.info("complete ClinicalDisplay getImageSystemGlobalNode transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch (ClassCastException e)
        {
			// the URN.create() can throw a ClassCastException if the string URN has the wrong namespace identifier
			String msg = "'" + imageId + "' is not a valid image identifier (ImageURN).";
			logger.info(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(e.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", e);
        } 
		catch(URNFormatException iurnfX)
		{
			logger.info("FAIlED getImageSystemGlobalNode transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			logger.info("FAILED getImageSystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", infX);
			transactionContext.setErrorMessage(infX.getMessage());
			transactionContext.setExceptionClassName(infX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image global node", infX);
		}
		catch(ConnectionException ioX)
		{
			logger.info("FAILED getImageSystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", ioX);
			transactionContext.setErrorMessage(ioX.getMessage());
			transactionContext.setExceptionClassName(ioX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image global node", ioX);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED getImageSystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image global node", mX);
		}
	}

	@Override
	public String getStudySystemGlobalNode(String studyId, String transactionId, 
		UserCredentials credentials)
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getStudySystemGlobalNode transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		AbstractImagingURN urn = null;
		try
		{
			urn = URNFactory.create(studyId, SERIALIZATION_FORMAT.CDTP, AbstractImagingURN.class);
			transactionContext.setPatientID(urn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getStudySystemGlobalNode");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(urn.toString());
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			String response = rtr.getImageSystemGlobalNode(urn);
			logger.info("complete ClinicalDisplay getStudySystemGlobalNode transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch (ClassCastException e)
        {
			// the URN.create() can throw a ClassCastException if the string URN has the wrong namespace identifier
			String msg = "'" + studyId + "' is not a valid imaging identifier (StudyURN or ImageURN).";
			logger.info(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(e.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study Id", e);
        } 
		catch(URNFormatException iurnfX)
		{
			logger.info("FAIlED getStudySystemGlobalNode transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			logger.info("FAILED getStudySystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", infX);
			transactionContext.setErrorMessage(infX.getMessage());
			transactionContext.setExceptionClassName(infX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image global node", infX);
		}
		catch(ConnectionException ioX)
		{
			logger.info("FAILED getStudySystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", ioX);
			transactionContext.setErrorMessage(ioX.getMessage());
			transactionContext.setExceptionClassName(ioX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image global node", ioX);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED getStudySystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image global node", mX);
		}
	}

	@Override
	public String getImageDevFields(String imageId, String flags, String transactionId, 
			UserCredentials credentials)
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getImageDevFields transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		ImageURN imageUrn = null;
		try{
			imageUrn = URNFactory.create(imageId, SERIALIZATION_FORMAT.CDTP, ImageURN.class);
			transactionContext.setPatientID(imageUrn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageDevFields");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(imageUrn.toString());
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			String response = rtr.getImageDevFields(imageUrn, flags);
			logger.info("complete ClinicalDisplay getImageDevFields transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch (ClassCastException e)
        {
			// the URN.create() can throw a ClassCastException if the string URN has the wrong namespace identifier
			String msg = "'" + imageId + "' is not a valid image identifier (ImageURN).";
			logger.info(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(e.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", e);
        } 
		catch(URNFormatException iurnfX)
		{
			logger.info("FAIlED getImageDevFields transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			logger.info("FAILED getImageDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", infX);
			transactionContext.setErrorMessage(infX.getMessage());
			transactionContext.setExceptionClassName(infX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image dev fields", infX);
		}
		catch(ConnectionException ioX)
		{
			logger.info("FAILED getImageDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", ioX);
			transactionContext.setErrorMessage(ioX.getMessage());
			transactionContext.setExceptionClassName(ioX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image dev fields", ioX);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED getImageDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image dev fields", mX);
		}
	}

	@Override
	public String getStudyDevFields(String studyId, String flags, String transactionId, 
			UserCredentials credentials)
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getStudyDevFields transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		AbstractImagingURN urn = null;
		try{
			urn = URNFactory.create(studyId, SERIALIZATION_FORMAT.CDTP, AbstractImagingURN.class);
			transactionContext.setPatientID(urn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getStudyDevFields");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(urn.toString());
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			String response = rtr.getImageDevFields(urn, flags);
			logger.info("complete ClinicalDisplay getStudyDevFields transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch(URNFormatException iurnfX)
		{
			logger.info("FAIlED getStudyDevFields transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			logger.info("FAILED getStudyDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", infX);
			transactionContext.setErrorMessage(infX.getMessage());
			transactionContext.setExceptionClassName(infX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image dev fields", infX);
		}
		catch(ConnectionException ioX)
		{
			logger.info("FAILED getStudyDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", ioX);
			transactionContext.setErrorMessage(ioX.getMessage());
			transactionContext.setExceptionClassName(ioX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image dev fields", ioX);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED getStudyDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image dev fields", mX);
		}
	}

	private void setTransactionContext(
			gov.va.med.imaging.clinicaldisplay.webservices.soap.v2.UserCredentials credentials,
			String transactionId)
	{
		logger.info(
				"setTransactionContext, id='" + transactionId + 
				"', username='" + credentials == null || credentials.getFullname() == null ? "null" : credentials.getFullname() + 
				"'.");
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		if(transactionId != null)
			transactionContext.setTransactionId(transactionId);
		
		if(credentials != null)
		{
			if( credentials.getFullname() != null )
				transactionContext.setFullName(credentials.getFullname());
			if( credentials.getSiteNumber() != null )
				transactionContext.setSiteNumber(credentials.getSiteNumber());
			if( credentials.getSiteName() != null )
				transactionContext.setSiteName(credentials.getSiteName());
			if( credentials.getDuz() != null )
				transactionContext.setPurposeOfUse(credentials.getDuz());
			if( credentials.getSsn() != null )
				transactionContext.setSsn(credentials.getSsn());
			if(credentials.getDuz() != null)
				transactionContext.setDuz(credentials.getDuz());
			transactionContext.setPurposeOfUse(PurposeOfUse.routineMedicalCare.getDescription());
		}
	}
	
	private String getWepAppName()
	{
		return "Clinical Display WebApp V2";
	}
}
