/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.clinicaldisplay;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class ClinicalDisplayRouterTest
 //extends  gov.va.med.imaging.ImagingBaseWebFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public ClinicalDisplayRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientSensitiveValue(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientSensitivityLevelCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.PatientSensitiveValue.class, 
	 				"GetPatientSensitivityLevelCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientSensitivityLevelCommand' in method 'getPatientSensitiveValue' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageAnnotations(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageAnnotationListByImageUrnCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotation.class, 
 				"GetImageAnnotationListByImageUrnCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.AbstractImagingURN.class 
	  			},
				new Object[]{
			 		imagingUrn
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetImageAnnotationListByImageUrnCommand' in method 'getImageAnnotations' with parameters 'gov.va.med.imaging.AbstractImagingURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageAnnotationDetails(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, gov.va.med.imaging.ImageAnnotationURN imageAnnotationUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageAnnotationDetailsCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN, gov.va.med.imaging.ImageAnnotationURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails.class, 
	 				"GetImageAnnotationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, gov.va.med.imaging.ImageAnnotationURN.class 
		  			},
 					new Object[]{
				 		imagingUrn,imageAnnotationUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageAnnotationDetailsCommand' in method 'getImageAnnotationDetails' with parameters 'gov.va.med.imaging.AbstractImagingURN, gov.va.med.imaging.ImageAnnotationURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void storeImageAnnotation(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, java.lang.String annotationDetails
 		 			, java.lang.String annotationVersion
 		 			, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource annotationSource
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostImageAnnotationDetailsCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN, java.lang.String, java.lang.String, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotation.class, 
	 				"PostImageAnnotationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource.class 
		  			},
 					new Object[]{
				 		imagingUrn,annotationDetails,annotationVersion,annotationSource
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostImageAnnotationDetailsCommand' in method 'storeImageAnnotation' with parameters 'gov.va.med.imaging.AbstractImagingURN, java.lang.String, java.lang.String, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void isSiteAnnotationSupported(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetSiteAnnotationSupportedStatusCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"GetSiteAnnotationSupportedStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetSiteAnnotationSupportedStatusCommand' in method 'isSiteAnnotationSupported' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getUserInformation(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetUserInformationFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.UserInformation.class, 
	 				"GetUserInformationFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetUserInformationFromDataSourceCommand' in method 'getUserInformation' with parameters 'gov.va.med.RoutingToken'.");
 		}

 }