package gov.va.med.imaging.url.classpath;


import static org.junit.Assert.*;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestClasspathConnection {

	@Before
	public void setUp() 
	throws Exception
	{
		String handlerPackages = System.getProperty("java.protocol.handler.pkgs");
		System.setProperty("java.protocol.handler.pkgs",
				handlerPackages == null || handlerPackages.length() == 0 ? 
						"gov.va.med.imaging.url" : 
						handlerPackages + "|" + "gov.va.med.imaging.url");
		System.out.println("java.protocol.handler.pkgs: " + System.getProperty("java.protocol.handler.pkgs"));
	}

	@Test
	public void testUrlAvailability() 
	throws IOException
	{
		try
        {
	        URL url = new URL("classpath://test.txt");
	        assertTrue(url != null);
	        
	        URLConnection connection = url.openConnection();
	        assertTrue(connection != null);
	        
	        InputStream inStream = connection.getInputStream();
	        assertTrue(inStream != null);
	        
	        int ch;
	        while( (ch = inStream.read()) != -1 )
	        	System.out.print((char)ch);
        	System.out.println("");
        	inStream.close();
        	
        }
		catch (MalformedURLException e)
        {
			fail("Protocol 'classpath' is not available.");
        }
	}
	@Test
	public void testUrlWithDirectoryAvailability() 
	throws IOException
	{
		try
        {
	        URL url = new URL("classpath://junk/test.txt");
	        assertTrue(url != null);
	        
	        URLConnection connection = url.openConnection();
	        assertTrue(connection != null);
	        
	        InputStream inStream = connection.getInputStream();
	        assertTrue(inStream != null);
	        
	        int ch;
	        while( (ch = inStream.read()) != -1 )
	        	System.out.print((char)ch);
        	System.out.println("");
        	inStream.close();
        	
        }
		catch (MalformedURLException e)
        {
			fail("Protocol 'classpath' is not available.");
        }
	}
}
