package gov.va.med.imaging.url.classpath;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

/**
 * 
 * @author       DNS
 *
 */
public class Handler 
extends URLStreamHandler
{
	public final static String PROTOCOL = "classpath";

    /** The classloader to find resources from. */
    private final ClassLoader classLoader;

    public Handler() 
    {
        this.classLoader = getClass().getClassLoader();
    }

    public Handler(ClassLoader classLoader) 
    {
        this.classLoader = classLoader;
    }

    @Override
    protected URLConnection openConnection(URL url) 
    throws IOException 
    {
		if(url == null)
			throw new MalformedURLException("Null URL passed to gov.va.med.imaging.url.classpath.Handler.openConnection()");
		
		if(url.getProtocol() == null)
			throw new MalformedURLException("Null protocol in URL passed to gov.va.med.imaging.url.classpath.Handler.openConnection()");
		if(url.getHost() == null)
			throw new MalformedURLException("Null host in URL passed to gov.va.med.imaging.url.classpath.Handler.openConnection()");
		if(!PROTOCOL.equals(url.getProtocol()) )
			throw new MalformedURLException("Unsupported protocol '" + url.getProtocol() + 
					"' passed to gov.va.med.imaging.url.classpath.Handler.openConnection()");
		
		String resourceLocation = url.getHost() + url.getPath();
        System.out.println("Create URL " + resourceLocation); 
        URL fileUrl = classLoader.getResource(resourceLocation);
        System.out.println("Opening connection to " + fileUrl.toString());
        return fileUrl.openConnection();
    }
}
