/**
 * 
 */
package gov.va.med.imaging.storage.cache.mock;

import java.net.URI;
import java.util.Collection;

import gov.va.med.imaging.storage.cache.*;
import gov.va.med.imaging.storage.cache.exceptions.CacheException;
import gov.va.med.imaging.storage.cache.exceptions.CacheStateException;
import gov.va.med.imaging.storage.cache.exceptions.RegionInitializationException;
import gov.va.med.imaging.storage.cache.memento.CacheMemento;
import gov.va.med.imaging.storage.cache.memento.RegionMemento;

/**
 * @author       BECKEC
 *
 */
public class MockCache 
implements Cache
{
	private Boolean enabled = Boolean.TRUE;
	private Boolean initialized = Boolean.TRUE;
	
	public static MockCache create()
	{
		return new MockCache();
	}
	
	
	@Override
	public Boolean isEnabled()
	{
		return enabled;
	}

	@Override
	public Boolean isInitialized()
	{
		return initialized;
	}
	@Override
	public void setEnabled(Boolean enabled) 
	throws CacheException
	{
		this.enabled = enabled;
	}

	@Override
	public void setInitialized(Boolean initialized) 
	throws CacheException
	{
		this.initialized = initialized;
	}

	@Override
	public String getLocationPath()
	{
		return null;
	}

	@Override
	public String getLocationProtocol()
	{
		return null;
	}

	@Override
	public URI getLocationUri()
	{
		return null;
	}

	@Override
	public String getName()
	{
		return null;
	}
	
	@Override
	public EvictionTimer getEvictionTimer()
	{
		return null;
	}

	// =================================================================================================================================
	// Eviction Strategies
	// =================================================================================================================================
	@Override
	public void addEvictionStrategies(Collection<? extends EvictionStrategy> evictionStrategies) 
	throws CacheStateException
	{
	}

	@Override
	public void addEvictionStrategy(EvictionStrategy evictionStrategy) 
	throws CacheStateException
	{
	}

	@Override
	public Collection<? extends EvictionStrategy> getEvictionStrategies()
	{
		return null;
	}

	@Override
	public EvictionStrategy getEvictionStrategy(String name)
	{
		return null;
	}
	
	// =================================================================================================================================
	// Region 
	// =================================================================================================================================
	@Override
	public Region createRegion(String name, String[] evictionStrategyNames) 
	throws RegionInitializationException
	{
		return null;
	}

	@Override
	public Region createRegion(RegionMemento regionMemento) 
	throws RegionInitializationException
	{
		return null;
	}

	@Override
	public void addRegion(Region region) 
	throws CacheException
	{

	}

	@Override
	public void addRegions(Collection<? extends Region> regions) 
	throws CacheException
	{

	}

	@Override
	public Region getRegion(String string)
	{
		return null;
	}

	@Override
	public Collection<? extends Region> getRegions()
	{
		return null;
	}
	
	// =================================================================================================================================
	// Instances
	// =================================================================================================================================
	@Override
	public void clear() 
	throws CacheException
	{

	}

	@Override
	public CacheMemento createMemento()
	{
		return null;
	}



	@Override
	public Instance getInstance(String regionName, String[] group, String key) 
	throws CacheException
	{
		return null;
	}

	@Override
	public void deleteInstance(String regionName, String[] group, String key, boolean forceDelete) 
	throws CacheException
	{
		return;
	}
	
	@Override
	public void deleteGroup(String regionName, String[] group, boolean forceDelete) 
	throws CacheException
	{
		return;
	}
	
	@Override
	public Group getOrCreateGroup(String regionName, String[] group)
	throws CacheException 
	{
		return null;
	}


	@Override
	public Group getGroup(String regionName, String[] groupsName)
	throws CacheException 
	{
		return null;
	}


	@Override
	public InstanceByteChannelFactory<?> getInstanceByteChannelFactory()
	{
		return null;
	}

	@Override
	public Instance getOrCreateInstance(String regionName, String[] group, String key) 
	throws CacheException
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Cache#registerCacheStructureChangeListener(gov.va.med.imaging.storage.cache.CacheStructureChangeListener)
	 */
	@Override
	public void registerCacheStructureChangeListener(CacheStructureChangeListener listener)
	{
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Cache#unregisterCacheStructureChangeListener(gov.va.med.imaging.storage.cache.CacheStructureChangeListener)
	 */
	@Override
	public void unregisterCacheStructureChangeListener(CacheStructureChangeListener listener)
	{
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.CacheLifecycleListener#cacheLifecycleEvent(gov.va.med.imaging.storage.cache.CacheLifecycleEvent)
	 */
	@Override
	public void cacheLifecycleEvent(CacheLifecycleEvent event) throws CacheStateException
	{
	}

}
