/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.memory;

import gov.va.med.imaging.storage.cache.AbstractTestCacheMemento;
import gov.va.med.imaging.storage.cache.Cache;
import gov.va.med.imaging.storage.cache.impl.memory.MemoryCache;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * @author      DNS
 *
 */
public class TestCacheMemento 
extends AbstractTestCacheMemento
{
	/**
	 * @return
	 * @throws URISyntaxException
	 */
	protected URI getCacheUri() 
	throws URISyntaxException
	{
		return new URI(MemoryCache.protocol + "://" + this.getName() + "?" + "maxSize=65536&maxInstanceCount=32");
	}
	
	protected void validateCacheRealizationClass(Cache cache)
	{
		assertTrue( cache instanceof MemoryCache );
	}
	
	protected String getCacheName()
	{
		return this.getClass().getSimpleName();
	}
}
