package gov.va.med.imaging.storage.cache.impl.memory.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * The Factory acts like a device, simulating out of space
 * conditions.
 */
public class MemoryInstanceDataFactory
{
	private Map<Integer, MemoryInstanceData> instanceMap = new HashMap<Integer, MemoryInstanceData>();
	private long deviceSize;
	private long availableSpace;
	
	public MemoryInstanceDataFactory(long deviceSize)
	{
		this.deviceSize = deviceSize;
		this.availableSpace = this.deviceSize;
	}
	
	public MemoryInstanceData getOrCreate(Integer instanceId, int bufferSize)
	{
		synchronized (instanceMap)
		{
			MemoryInstanceData instance = get(instanceId);
			if(instance == null)
			{
				instance = new MemoryInstanceData(this, bufferSize);
				instanceMap.put(instanceId, instance);
			}
			
			return instance;
		}
	}
	
	public MemoryInstanceData get(Integer instanceId)
	{
		synchronized (instanceMap)
		{
			return instanceMap.get(instanceId);
		}
	}
	
	public long getFreeSpace()
	{
		return availableSpace;
	}
	
	void instanceBytesWritten(int bytesWritten)
	throws IOException
	{
		if(bytesWritten > this.availableSpace)
			throw new IOException("No available space");
		this.availableSpace -= bytesWritten;
	}
	
	/**
	 * Removing the instance deletes the storage of the instance, like
	 * deleting a file if the instance was stored persistently. 
	 * @param instanceId
	 */
	public void instanceRemoved(Integer instanceId)
	{
		MemoryInstanceData data = instanceMap.get(instanceId);
		instanceMap.remove(instanceId);
		this.availableSpace += data.getCapacity();
	}
}