package gov.va.med.imaging.storage.cache.impl.memory.data;

import java.io.IOException;

import gov.va.med.imaging.channels.ChecksumValue;

/**
 * Transient storage for small Instances, mostly used for testing.
 * 
 * @author      DNS
 *
 */
public class MemoryInstanceData
{
	// ====================================================================================================================================
	// Instance Members
	// ====================================================================================================================================
	private MemoryInstanceDataFactory factory;
	private byte[] byteBuffer;
	private int limit;
	private ChecksumValue checksumValue;
	private boolean removed = false;
	
	/**
	 * DO NOT USE THIS CONSTRUCTOR, instances of MockInstanceData must be constructed through a MockInstanceDataFactory
	 * instance.
	 * 
	 * @param factory
	 * @param bufferSize
	 */
	MemoryInstanceData(MemoryInstanceDataFactory factory, int bufferSize)
	{
		this.factory = factory;
		byteBuffer = new byte[bufferSize];
	}

	public ChecksumValue getChecksumValue()
	{
		return this.checksumValue;
	}

	public void setChecksumValue(ChecksumValue checksumValue)
	{
		this.checksumValue = checksumValue;
	}
	
	public int getLimit()
	{
		return this.limit;
	}
	
	public int getCapacity()
	{
		return this.byteBuffer.length;
	}

	private byte[] getByteBuffer()
	{
		return this.byteBuffer;
	}
	
	public byte[] read(int start, int length)
	throws IOException
	{
		if(isRemoved())
			throw new IOException("Instance has been removed.");
		
		byte[] src = getByteBuffer();
		
		int end = Math.min(start+length, src.length);
		byte[] dst = new byte[end-start];
		
		for(int index=start; index < end; ++index)
			dst[index-start] = src[index];
		
		return dst;
	}
	
	public void write(int start, byte[] src) 
	throws IOException
	{
		if(isRemoved())
			throw new IOException("Instance has been removed.");
		
		factory.instanceBytesWritten(src.length);
		
		byte[] dst = getByteBuffer();
		for(int index=0; index < src.length; ++index)
			dst[start + index] = src[index];
		
		limit = Math.max(limit, Math.min(dst.length, start+src.length));
	}
	
	public void remove()
	{
		if(! isRemoved())
		{
			limit = 0;
			checksumValue = null;
			byteBuffer = null;
		}
		this.removed = true;
	}
	
	public boolean isRemoved()
	{
		return this.removed;
	}
}