/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.memory;

import gov.va.med.imaging.storage.cache.Cache;
import gov.va.med.imaging.storage.cache.EvictionStrategy;
import gov.va.med.imaging.storage.cache.GroupFactory;
import gov.va.med.imaging.storage.cache.InstanceFactory;
import gov.va.med.imaging.storage.cache.exceptions.RegionInitializationException;
import gov.va.med.imaging.storage.cache.memento.RegionMemento;

/**
 * @author      DNS
 *
 */
public class MemoryRegionFactory
{
	private final GroupFactory groupFactory;
	private final InstanceFactory instanceFactory;
	
	MemoryRegionFactory(GroupFactory groupFactory, InstanceFactory instanceFactory)
	{
		this.instanceFactory = instanceFactory;
		this.groupFactory = groupFactory;
	}
	
	/**
	 * @return the groupFactory
	 */
	public GroupFactory getGroupFactory()
	{
		return this.groupFactory;
	}

	/**
	 * @return the instanceFactory
	 */
	public InstanceFactory getInstanceFactory()
	{
		return this.instanceFactory;
	}

	public MemoryRegion create(Cache parentCache, String name, EvictionStrategy[] regionEvictionStrategies)
	throws RegionInitializationException
	{
		return new MemoryRegion(parentCache, name, regionEvictionStrategies, getGroupFactory(), getInstanceFactory());
	}

	public MemoryRegion create(Cache parentCache, RegionMemento regionMemento, EvictionStrategy[] regionEvictionStrategies)
	throws RegionInitializationException
	{
		return new MemoryRegion(parentCache, regionMemento.getName(), regionEvictionStrategies, getGroupFactory(), getInstanceFactory());
	}
}
