/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.memory;

import gov.va.med.imaging.storage.cache.Instance;
import gov.va.med.imaging.storage.cache.InstanceByteChannelFactory;
import gov.va.med.imaging.storage.cache.InstanceFactory;
import gov.va.med.imaging.storage.cache.events.GroupLifecycleListener;
import gov.va.med.imaging.storage.cache.events.InstanceLifecycleListener;
import gov.va.med.imaging.storage.cache.exceptions.CacheException;

/**
 * @author       DNS
 *
 */
public class MemoryInstanceFactory 
extends InstanceFactory
{
	private final InstanceLifecycleListener instanceLifecycleListener;
	private final MemoryInstanceByteChannelFactory byteChannelFactory;

	// ==================================================================================================================
	// 
	// ==================================================================================================================
	
	MemoryInstanceFactory(MemoryInstanceByteChannelFactory byteChannelFactory, InstanceLifecycleListener instanceLifecycleListener)
	{
		this.instanceLifecycleListener = instanceLifecycleListener;
		this.byteChannelFactory = byteChannelFactory;
	}
	

	public InstanceLifecycleListener getInstanceLifecycleListener()
	{
		return instanceLifecycleListener;
	}

	public MemoryInstanceByteChannelFactory getByteChannelFactory()
	{
		return this.byteChannelFactory;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.InstanceFactory#createInstance(java.lang.String)
	 */
	public Instance create(String name) 
	throws CacheException
	{
		Instance instance = new MemoryInstance(getByteChannelFactory(), name);

		if(getInstanceLifecycleListener() != null)
			instance.registerListener( getInstanceLifecycleListener() );
		
		return instance;
	}

}
