/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.memory;

import gov.va.med.imaging.channels.ChecksumValue;
import gov.va.med.imaging.storage.cache.*;
import gov.va.med.imaging.storage.cache.events.InstanceLifecycleEvent;
import gov.va.med.imaging.storage.cache.events.InstanceLifecycleListener;
import gov.va.med.imaging.storage.cache.events.LifecycleEvent;
import gov.va.med.imaging.storage.cache.exceptions.CacheException;
import gov.va.med.imaging.storage.cache.exceptions.InstanceInvalidStateException;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author       DNS
 *
 */
public class MemoryInstance 
implements Instance, InstanceByteChannelListener
{
	private final Integer id = new Integer( (new Object()).hashCode() );		// a unique ID within the process
	private String name;
	private Date lastAccessed = new Date();
	private ChecksumValue checksumValue;
	
	private MemoryInstanceByteChannelFactory byteChannelFactory;
	
	public MemoryInstance(MemoryInstanceByteChannelFactory byteChannelFactory, String name)
	{
		super();
		this.byteChannelFactory = byteChannelFactory;
		this.name = name;
	}

	public String getName()
	{
		return name;
	}

	/**
	 * @return the byteChannelFactory
	 */
	public MemoryInstanceByteChannelFactory getByteChannelFactory()
	{
		return this.byteChannelFactory;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Instance#getChecksumValue()
	 */
	@Override
	public String getChecksumValue()
	{
		return checksumValue == null ? null : checksumValue.toString();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Instance#getLastAccessed()
	 */
	@Override
	public Date getLastAccessed() 
	throws CacheException
	{
		return lastAccessed;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Instance#getSize()
	 */
	@Override
	public long getSize() 
	throws CacheException
	{
		return 0;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Instance#getWritableChannel()
	 */
	@Override
	public InstanceWritableByteChannel getWritableChannel() 
	throws CacheException
	{
		return getWritableChannel(true);
	}
	@Override
	public InstanceWritableByteChannel getWritableChannelNoWait() 
	throws CacheException
	{
		return getWritableChannel(false);
	}
	private InstanceWritableByteChannel getWritableChannel(boolean wait) 
	throws CacheException
	{
		lastAccessed = new Date();
		return byteChannelFactory.getInstanceWritableByteChannel(id, this);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Instance#getReadableChannel()
	 */
	@Override
	public InstanceReadableByteChannel getReadableChannel() 
	throws CacheException
	{
		return getReadableChannel(true);
	}
	
	@Override
	public InstanceReadableByteChannel getReadableChannelNoWait() 
	throws CacheException
	{
		return getReadableChannel(false);
	}
	private InstanceReadableByteChannel getReadableChannel(boolean wait) 
	throws CacheException
	{
		lastAccessed = new Date();
		return byteChannelFactory.getInstanceReadableByteChannel(id, this);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Instance#isPersistent()
	 */
	@Override
	public boolean isPersistent() 
	throws CacheException
	{
		return false;
	}

	@Override
	public String getMediaType() 
	{
		return null;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Instance#remove()
	 */
	@Override
	public void delete(boolean forceDelete) 
	throws CacheException
	{
		getByteChannelFactory().remove(this.id);
		notifyListeners(LifecycleEvent.DELETE);
	}

	// ==============================================================================================================
	// 
	// ==============================================================================================================
	public void readChannelClose(InstanceReadableByteChannel readable)
	{
	}
	public void readChannelIdleTimeout(InstanceReadableByteChannel readable)
	{
	}
	public void writeChannelClose(InstanceWritableByteChannel writable)
	{
		checksumValue = new ChecksumValue(writable.getChecksum());
	}
	public void writeChannelIdleTimeout(InstanceWritableByteChannel writable)
	{
	}
	
	// ==============================================================================================================
	// 
	// ==============================================================================================================
	
	private List<InstanceLifecycleListener> listeners = new ArrayList<InstanceLifecycleListener>();
	public void registerListener(InstanceLifecycleListener listener)
	{
		listeners.add(listener);
	}
	
	public void unregisterListener(InstanceLifecycleListener listener)
	{
		listeners.remove(listener);
	}
	
	protected void notifyListeners(LifecycleEvent event)
	{
		InstanceLifecycleEvent lifecycleEvent = new InstanceLifecycleEvent(event, getName());
		for(InstanceLifecycleListener listener : listeners)
			listener.notify(lifecycleEvent);
	}

}
