/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.memory;

import gov.va.med.imaging.storage.cache.Group;
import gov.va.med.imaging.storage.cache.GroupFactory;
import gov.va.med.imaging.storage.cache.MutableNamedObjectSet;
import gov.va.med.imaging.storage.cache.exceptions.CacheException;

import java.util.Set;

/**
 * @author       DNS
 *
 */
public class GroupSet
extends MutableNamedObjectSet<Group>
implements Set<Group>
{
	private static final long serialVersionUID = 1L;
	
	public GroupSet(GroupFactory groupFactory)
	{
		super(groupFactory);
	}

	/**
	 * Recursively 
	 * @param path
	 * @return
	 * @throws CacheException
	 */
	public Group getByName(String[] path) 
	throws CacheException
	{
		if(path == null || path.length < 1)
			return null;
		
		String childGroupName = path[0];
		Group childGroup = getByName(childGroupName);
		if(path.length == 1)
			return childGroup;
		else
		{
			String[] groupAncestorPath = new String[path.length-1];
			System.arraycopy(path, 1, groupAncestorPath, 0, path.length-1);
			return childGroup.getGroup( groupAncestorPath );
		}
	}
	
	/**
	 * 
	 * @param namePath
	 * @return
	 * @throws CacheException 
	 */
	public Group getOrCreateByName(String[] path) 
	throws CacheException
	{
		if(path == null || path.length < 1)
			return null;
		
		String childGroupName = path[0];
		Group childGroup = getOrCreateByName(childGroupName);
		if(path.length == 1)
			return childGroup;
		else
		{
			String[] groupAncestorPath = new String[path.length-1];
			System.arraycopy(path, 1, groupAncestorPath, 0, path.length-1);
			return childGroup.getOrCreateGroup( groupAncestorPath );
		}
	}
}
