/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.jcifs;

import gov.va.med.imaging.storage.cache.Cache;
import gov.va.med.imaging.storage.cache.exceptions.CacheException;
import gov.va.med.imaging.storage.cache.exceptions.CacheStateException;
import gov.va.med.imaging.storage.cache.exceptions.InitializationException;
import gov.va.med.imaging.storage.cache.exceptions.InvalidSweepSpecification;
import gov.va.med.imaging.storage.cache.impl.CacheConfigurator;
import gov.va.med.imaging.storage.cache.timer.EvictionTimerImpl;

import java.util.HashMap;
import java.util.Map;

/**
 * @author       DNS
 *
 */
public class JcifsCacheConfigurator
implements CacheConfigurator
{

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.impl.CacheConfigurator#getEvictionTimerSweepIntervalMap()
	 */
	public Map<Long, String> getEvictionTimerSweepIntervalMap()
	{
		Map<Long, String> sweepIntervalMap = new HashMap<Long, String>();
		
		sweepIntervalMap.put(new Long(60000L), "0000:00:00:00:00:10"); 		// if less than a minute then next 10 seconds, this is mostly here for testing
		sweepIntervalMap.put(new Long(3600000), "0000:00:00:00:01:00"); 	// if less than an hour then next minute
		sweepIntervalMap.put(new Long(86400000), "0000:00:00:01:00:00"); 	// if less than a day then next hour
		sweepIntervalMap.put(EvictionTimerImpl.defaultAgeSpecification, "0000:00:01:00:00:00@0000:00:00:03:00:00"); // else, run it once a day at 3AM
		
		return sweepIntervalMap;
	}

}
