<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%@ page session="false" %>
<%@page import="gov.va.med.imaging.transactioncontext.TransactionContext"%>
<%@page import="gov.va.med.imaging.transactioncontext.TransactionContextFactory"%>
<%@page import="gov.va.med.imaging.encryption.AesEncryption"%>
<%@page import="gov.va.med.imaging.awiv.configuration.AwivClientConfiguration"%>
<%@page import="gov.va.med.imaging.awiv.client.ui.widgets.AwivConstants" %>
<%@page import="gov.va.med.imaging.url.vista.StringUtils" %>
<%@page import="javax.servlet.http.Cookie" %>
<%@page import="java.net.URLDecoder" %>
<%
String path = request.getContextPath();
String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/";

Cookie [] cookies = request.getCookies();
String inputParameters = null;
if(cookies != null)
{
	for(Cookie cookie : cookies)
	{
		if(AwivConstants.awivParametersCookie.equals(cookie.getName()))
		{
			inputParameters = cookie.getValue();
			cookie.setMaxAge(0); // delete the cookie
			response.addCookie(cookie);
			break;
		}
	}
}
//System.out.println("Parameters: " + inputParameters );

String patientIcn = null;// request.getParameter("patientIcn");
String patientName = null;//request.getParameter("patientName");
String patientSsn = null;//request.getParameter("patientSsn");
String identifier = null;//request.getParameter("identifier");
String viewType = null;//request.getParameter("viewType");
String identifierSiteNumber = null;//request.getParameter("identifierSiteNumber");
String userHasNcatKey = null;//request.getParameter("hasNcatKey");
String patientLookupSite = null;//request.getParameter("patientLookupSite");
String userHasMagRoiKey = "";

if(inputParameters != null)
{
	inputParameters = URLDecoder.decode(inputParameters, "UTF-8");
	//System.out.println("URL decoded parameters: " + inputParameters);
	String [] pieces = StringUtils.Split(inputParameters, AwivConstants.awivParametersDelimiter);// "%7C");
	patientIcn = pieces[0];
	patientName = pieces[1];
	patientSsn = pieces[2];
	identifier = pieces[3];
	viewType = pieces[4];
	identifierSiteNumber = pieces[5];
	userHasNcatKey = pieces[6];
	patientLookupSite = pieces[7];
	if(pieces.length > 8)
		userHasMagRoiKey = pieces[8];
}
if(patientLookupSite == null)
	patientLookupSite = "";
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
  <head>
  	<!-- 
    <base href="<%=basePath%>">
     -->
    
    <title>VistA Imaging Advanced Web Image Viewer - <%= patientName %></title>
    
	<meta http-equiv="pragma" content="no-cache">
	<meta http-equiv="cache-control" content="no-cache">
	<meta http-equiv="expires" content="0">    
	<meta http-equiv="keywords" content="keyword1,keyword2,keyword3">
	<meta http-equiv="description" content="This is my page">
	
	<link rel="stylesheet" type="text/css" href="style.css">
	
	
	<script for="AWIVControl" event="OnGeneralError" language="javascript" type="text/javascript">
		alert("General Error");
	</script>
	
	<script for="AWIVControl" event="OnDecryptError" language="javascript" type="text/javascript">
	  	alert("Decryption Error");
	</script>
	
	<script for="AWIVControl" event="OnParamsError" language="javascript" type="text/javascript">
	  	alert("Params Error");
	</script>
  </head>  
  <body>
    <%
    	AwivClientConfiguration configuration = AwivClientConfiguration.getConfiguration();
    
    	StringBuilder awivParameters = new StringBuilder(); 
    	byte[] iv = null; 
    	String encryptedAwivParameters = null;  	
    	
    	awivParameters.append("&A{" + patientName + "}");
    	awivParameters.append("&B{" + patientSsn + "}");
    	awivParameters.append("&C{" + patientIcn + "}");
    
    	TransactionContext context = TransactionContextFactory.get();    	    	
    
    	awivParameters.append("&D{" + identifier + "}");
    	
    	awivParameters.append("&E{" + identifierSiteNumber + "}");
    	awivParameters.append("&F{" + context.getFullName() + "}");
    	awivParameters.append("&G{" + context.getDuz() + "}");
    	awivParameters.append("&H{" + context.getSsn() + "}");
    	awivParameters.append("&I{" + context.getSiteName() + "}");
    	awivParameters.append("&J{" + context.getSiteNumber() + "}");    	
		awivParameters.append("&K{" + context.getBrokerSecurityToken() + "}"); // place holder saved for BSE token
		awivParameters.append("&L{" + configuration.getSiteServiceUrl() + "}");
		awivParameters.append("&M{" + configuration.getCvixSiteNumber() + "}"); // CVIX site in site service
		//awivParameters.append("&L{" + configuration.getSiteServiceUrl() + "}");
		//awivParameters.append("&M{" + configuration.getCvixSiteServiceSiteNumber() + "}"); // CVIX site in site service
		awivParameters.append("&O{" + viewType + "}"); // VI for VistA Imaging, VW for VistAWeb and VIDOD for DoD artifacts
		/*
		if(configuration.isCVIXSiteInformationIncluded())
		{
			awivParameters.append("&P{" + configuration.getCVIXSiteInformationParameterString() + "}");	
		} */
		awivParameters.append("&Q{" + userHasNcatKey + "}"); // 1 if the user has the key, 0 otherwise   
		awivParameters.append("&R{" + patientLookupSite + "}"); // the patient lookup site
		awivParameters.append("&S{" + userHasMagRoiKey + "}"); // 1 if the user has the key, 0 otherwise
		
		if (configuration.isUseSilverlightPlugin())
		{
			iv = AesEncryption.getInitializationVector();
			encryptedAwivParameters = AesEncryption.encrypt(iv, awivParameters.toString());
		}
		else
		{
			encryptedAwivParameters = AesEncryption.encrypt(awivParameters.toString());
		}
		//encryptedAwivParameters = AWIVClient.encrypt(awivParameters.toString());
     %>
     
     <%
     	if(configuration.isUseSilverlightPlugin())
     	{
     		// use the silverlight plugin here
     		%>
     		
			<object data="data:application/x-silverlight-2," 
					type="application/x-silverlight-2" 
					width="100%" 
					height="100%">
          		<param name="source" value="ClientBin/Viewer.xap"/>
          		<param name="onError" value="onSilverlightError" />
          		<param name="background" value="white" />
          		<param name="minRuntimeVersion" value="5.0.61118.0" />
          		<param name="autoUpgrade" value="true" />
	          	<param name="initParams" value="iv=<%= AesEncryption.encodeByteArray(iv) %>,ct=<%= encryptedAwivParameters %>" />
	          	<a href="http://go.microsoft.com/fwlink/?LinkID=149156&v=5.0.61118.0" style="text-decoration:none">
	            	<img src="http://go.microsoft.com/fwlink/?LinkId=161376" alt="Get Microsoft Silverlight" style="border-style:none"/>
	          	</a>
        	</object>
     		<%
     	}
     	else
     	{
      %>
     
     	<OBJECT
	        id='AWIVControl'
	        classid='clsid:5DE3D289-4FBE-4018-B042-75BD86C6A19F'
	        codebase='AWIV_ActiveFormProject1.ocx#version='
	        width='100%'
	        height='100%'
	        align='middle'>        
	        <param name='VW_ParmStr' value='<%= encryptedAwivParameters %>' />  
	        <div id="awiv-not-found">
	        	You do not have the AWIV component installed, this is required to view images.
	        </div>       
	    </OBJECT>
	    <%
	    } %>         
  </body>
</html>
