/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Nov 13, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.web;

import javax.servlet.http.HttpSession;

import gov.va.med.imaging.tomcat.vistarealm.VistaRealmPrincipal;
import gov.va.med.imaging.transactioncontext.TransactionContext;

/**
 * @author DNS
 *
 */
public class UserDetails 
{
	
	private String duz = null;
	private String ssn = null;
	private String siteNumber = null;
	private String siteName = null;
	private String accessCode = null;
	private String verifyCode = null;	
	
	private String userName = null;
	private String token = null;
	
	private boolean initialized = false;
	
	/**
	 * Default constructor so this object can be used as a bean
	 */
	public UserDetails()
	{
		// use default values
	}
	
	public UserDetails(TransactionContext transactionContext)
	{
		if(transactionContext != null)
		{
			duz = transactionContext.getDuz();
			ssn = transactionContext.getSsn();
			siteNumber = transactionContext.getSiteNumber();
			siteName = transactionContext.getSiteName();
			userName = transactionContext.getFullName();
			token = transactionContext.getBrokerSecurityToken();
			accessCode = transactionContext.getAccessCode();
			verifyCode = transactionContext.getVerifyCode();			
						
			if((getDuz() != null) && (getDuz().length() > 0))
				initialized = true;
		}
	}
	
	public UserDetails(VistaRealmPrincipal vistaRealmPrincipal)
	{
		if(vistaRealmPrincipal != null)
		{
			duz = vistaRealmPrincipal.getDuz();
			ssn = vistaRealmPrincipal.getSsn();
			siteNumber = vistaRealmPrincipal.getSiteNumber();
			siteName = vistaRealmPrincipal.getSiteName();
			userName = vistaRealmPrincipal.getFullName();
			token = vistaRealmPrincipal.getSecurityToken();
			accessCode = vistaRealmPrincipal.getAccessCode();
			verifyCode = vistaRealmPrincipal.getVerifyCode();			
						
			if((getDuz() != null) && (getDuz().length() > 0))
				initialized = true;
		}
	}
	
	public UserDetails(HttpSession session)
	{
		setUser(session);
	}
	
	public void setUser(HttpSession session)
	{
		if(session != null)
		{
			Object u = session.getAttribute("user");
			if(u != null)
			{
				UserDetails user = (UserDetails)u;
				this.duz = user.duz;
				this.siteName = user.siteName;
				this.siteNumber = user.siteNumber;
				this.ssn = user.ssn;
				this.token = user.token;
				this.userName = user.userName;
				this.accessCode = user.accessCode;
				this.verifyCode = user.verifyCode;
				if((getDuz() != null) && (getDuz().length() > 0))
					initialized = true;
			}
		}	
	}
	
	public void updateBrokerSecurityToken(String token)
	{
		this.token = token;
	}
	
	/*
	public void updateRequestCookies(HttpServletResponse response)
	{		
		int timeout = 60 * 60;// 1 hour		
		
		response.addCookie(bakeCookie("duz", this.duz, timeout));
		response.addCookie(bakeCookie("ssn", this.ssn, timeout));
		response.addCookie(bakeCookie("siteNumber", this.siteNumber, timeout));
		response.addCookie(bakeCookie("siteName", this.siteName, timeout));
		response.addCookie(bakeCookie("userName", this.userName, timeout));
		response.addCookie(bakeCookie("token", this.token, timeout));		
	}
	
	public void clearCookies(HttpServletResponse response)
	{
		int timeout = 0;		
		response.addCookie(bakeCookie("duz", "", timeout));
		response.addCookie(bakeCookie("ssn", "", timeout));
		response.addCookie(bakeCookie("siteNumber", "", timeout));
		response.addCookie(bakeCookie("siteName", "", timeout));
		response.addCookie(bakeCookie("userName", "", timeout));
		response.addCookie(bakeCookie("token", "", timeout));		
		response.addCookie(bakeCookie("agreedSensitiveLevel", "", timeout));
	}
	
	private Cookie bakeCookie(String name, String value, int timeout)
	{
		Cookie cookie = new Cookie(name, value);
		cookie.setMaxAge(timeout);
		return cookie;
	}*/

	/**
	 * @return the duz
	 */
	public String getDuz() {
		return duz;
	}

	/**
	 * @return the ssn
	 */
	public String getSsn() {
		return ssn;
	}

	/**
	 * @return the siteNumber
	 */
	public String getSiteNumber() {
		return siteNumber;
	}

	/**
	 * @return the siteName
	 */
	public String getSiteName() {
		return siteName;
	}

	/**
	 * @return the userName
	 */
	public String getUserName() {
		return userName;
	}

	/**
	 * @return the token
	 */
	public String getToken() {
		return token;
	}

	/**
	 * @return the initialized
	 */
	public boolean isInitialized() {
		return initialized;
	}

	/**
	 * @return the accessCode
	 */
	public String getAccessCode() {
		return accessCode;
	}

	/**
	 * @return the verifyCode
	 */
	public String getVerifyCode() {
		return verifyCode;
	}

}
