/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 6, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.web;

import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.imaging.ImageURN;
import gov.va.med.imaging.core.interfaces.ImageMetadataNotification;
import gov.va.med.imaging.core.interfaces.exceptions.SecurityCredentialsExpiredException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.enums.ImageFormat;
import gov.va.med.imaging.exchange.enums.ImageQuality;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.wado.AbstractBaseImageServlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.time.DateUtils;

/**
 * @author       DNS
 *
 */
public class AwivClientThumbnailImageServlet
extends AbstractBaseImageServlet
{
	private static final long serialVersionUID = 6860144237571388528L;

	@Override
	public String getUserSiteNumber()
	{
		return null;
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType("AWIV Client Web App image transfer");
		
		// need the image URN
		
		String pathInfo = request.getPathInfo();
		if(pathInfo == null || pathInfo.isEmpty())
		{
			response.sendError(HttpServletResponse.SC_BAD_REQUEST, "The image URN was not specified in the URL and must be.");
			return;
		}
		pathInfo = pathInfo.substring(1);
		String[] resourceIds = pathInfo.split("/");
		
		String imageUrnString = resourceIds[0];
		try
		{
			ImageURN imageUrn = URNFactory.create(imageUrnString, SERIALIZATION_FORMAT.CDTP, ImageURN.class);
			transactionContext.setPatientID(imageUrn.getPatientId());
			transactionContext.setUrn(imageUrnString);
			transactionContext.setQueryFilter("n/a");
			
			List<ImageFormat> acceptableResponseContent = new ArrayList<ImageFormat>();
			acceptableResponseContent.add(ImageFormat.JPEG);
			
			OutputStream outStream = response.getOutputStream();
			getLogger().info("Requesting thumbnail for image '" + imageUrnString + "'.");
			long bytesTransferred = streamImageInstanceByUrn(imageUrn, ImageQuality.THUMBNAIL, 
					acceptableResponseContent, outStream, 
					new AwivClientThumbnailMetadataNotification(response), false);
			
		
			transactionContext.setEntriesReturned( bytesTransferred==0 ? 0 : 1 );
			transactionContext.setFacadeBytesSent(bytesTransferred);
			transactionContext.setResponseCode(HttpServletResponse.SC_OK + "");
		}
		catch(URNFormatException urnfX)
		{
			String msg = "URNFormatException, " + urnfX.getMessage();
			getLogger().error(msg);
			transactionContext.setResponseCode(HttpServletResponse.SC_PRECONDITION_FAILED + "");
			transactionContext.setErrorMessage(msg);
			response.sendError(HttpServletResponse.SC_PRECONDITION_FAILED, msg);
		}
		catch(ImageServletException isX)
		{
			String msg = isX.getMessage();
			getLogger().error(msg);
			transactionContext.setResponseCode(isX.getResponseCode() + "");
			transactionContext.setErrorMessage(msg);
			response.sendError(isX.getResponseCode(), isX.getMessage());
		}
		catch(SecurityCredentialsExpiredException sceX)
		{
			String msg = "SecurityCredentials expired: " + sceX.getMessage();
			// logging of error already done
			// just need to set appropriate error code
			transactionContext.setResponseCode(HttpServletResponse.SC_PRECONDITION_FAILED + "");
			transactionContext.setErrorMessage(msg);
			response.sendError(HttpServletResponse.SC_PRECONDITION_FAILED, msg);
		}
		
	}
	
	class AwivClientThumbnailMetadataNotification
	implements ImageMetadataNotification
	{
		private final HttpServletResponse response;
		
		public AwivClientThumbnailMetadataNotification(HttpServletResponse response)
		{
			this.response = response;
		}

		/* (non-Javadoc)
		 * @see gov.va.med.imaging.core.interfaces.ImageMetadataNotification#imageMetadata(java.lang.String, gov.va.med.imaging.exchange.enums.ImageFormat, int, gov.va.med.imaging.exchange.enums.ImageQuality)
		 */
		@Override
		public void imageMetadata(String checksumValue,
				ImageFormat imageFormat, int fileSize, ImageQuality imageQuality)
		{
			response.setDateHeader( "Expires", DateUtils.addMonths( new Date(), 2 ).getTime() );
		}
		
	}

}
