/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 30, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.web;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import gov.va.med.PatientIdentifier;
import gov.va.med.imaging.awiv.business.UUID;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.wado.AbstractBasePhotoIdImageServlet;

/**
 * @author       DNS
 *
 */
public class AwivClientPhotoIdImageServlet
extends AbstractBasePhotoIdImageServlet
{
	private static final long serialVersionUID = 7524777641932250390L;

	@Override
	protected String getWebAppName()
	{
		return "AWIV Client Web App";
	}

	@Override
	protected String getWebAppVersion()
	{
		// no version for this application
		return null;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.wado.AbstractBasePhotoIdImageServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		TransactionContextFactory.get().setTransactionId(UUID.uuid());
		super.doGet(request, response);
	}

	@Override
	protected String getSiteNumber(HttpServletRequest request)
	{
		String pathInfo = request.getPathInfo();
		if(pathInfo == null || pathInfo.isEmpty())
		{
			return getUserDetails(request).getSiteNumber();
		}
		pathInfo = pathInfo.substring(1);
		String[] resourceIds = pathInfo.split("/");
		if(resourceIds.length > 1)
		{
			return resourceIds[0];
		}
		else
		{
			return getUserDetails(request).getSiteNumber();
		}		
	}

	@Override
	protected PatientIdentifier getPatientIdentifier(HttpServletRequest request)
	{
		String pathInfo = request.getPathInfo();
		if(pathInfo == null || pathInfo.isEmpty())
		{
			return null;
		}		
		pathInfo = pathInfo.substring(1);
		String[] resourceIds = pathInfo.split("/");
		String icn = null;
		if(resourceIds.length > 1)
		{
			icn = resourceIds[1];
		}
		else
		{
			icn = resourceIds[0];
		}
		if(icn != null)
			return PatientIdentifier.icnPatientIdentifier(icn);
		return null;
	}

	@Override
	public String getUserSiteNumber()
	{
		// user site number is used for image logging which isn't done for photo ID - not needed here
		return null;
	}
	
	
	protected UserDetails getUserDetails(HttpServletRequest request)
	{
		return new UserDetails(request.getSession(false));
	}

}
