/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: 
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ

  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.server;

import gov.va.med.RoutingToken;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.awiv.AWIVClientContext;
import gov.va.med.imaging.awiv.AWIVClientContextHolder;
import gov.va.med.imaging.awiv.AWIVClientRouter;
import gov.va.med.imaging.awiv.business.AwivSite;
import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.client.UserService;
import gov.va.med.imaging.awiv.client.ui.widgets.AwivConstants;
import gov.va.med.imaging.awiv.configuration.AwivClientConfiguration;
import gov.va.med.imaging.awiv.exceptions.AwivConnectionException;
import gov.va.med.imaging.awiv.exceptions.AwivMethodException;
import gov.va.med.imaging.awiv.exceptions.AwivUserNotLoggedInException;
import gov.va.med.imaging.awiv.server.translator.AwivClientTranslator;
import gov.va.med.imaging.awiv.web.UserDetails;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;

import java.util.Collections;
import java.util.List;

public class UserServiceImpl 
extends AbstractAwivClientRemoteServiceServlet 
implements UserService 
{
	private static final long serialVersionUID = 3268489946071855178L;

	@Override
	public AwivUserInformation getUserInformation(String transactionId)
	throws AwivConnectionException, AwivMethodException, AwivUserNotLoggedInException
	{
		UserDetails userDetails = getUserDetails();
		if(!userDetails.isInitialized())
		{
			throw new AwivUserNotLoggedInException("User is not fully authenticated");
		}
		List<String> keys = null;
		try
		{
			String siteNumber = getUserSiteNumber();
			// if this is a claims user, don't bother getting user keys (they don't have any)
			if(!AwivConstants.claimsServerSiteNumber.equals(siteNumber))
			{
				AWIVClientRouter router = AWIVClientContext.getRouter();				
				setTransactionContextProperties(transactionId, "getUserInformation");
				RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber);
				keys = router.getUserKeysCommand(routingToken);
			}			
		}	
		catch(RoutingTokenFormatException rtfX)
		{
			throw new AwivMethodException(rtfX);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			getLogger().warn(mX.getMessage());
		}
		String version = AWIVClientContextHolder.getAwivClientContext().getApplicationConfiguration().getVixSoftwareVersion();
		AwivClientConfiguration configuration = AwivClientConfiguration.getConfiguration();
		return new AwivUserInformation(userDetails.getDuz(), userDetails.getUserName(), 
				userDetails.getSsn(), userDetails.getSiteName(), userDetails.getSiteNumber(), 
				userDetails.getToken(), 
				(keys == null ? new String [0] : keys.toArray(new String[keys.size()])),
				AwivClientTranslator.translate(configuration, version));
	}

	@Override
	public AwivSite[] getPatientLookupSites(String transactionId)
	throws AwivConnectionException, AwivMethodException
	{
		try
		{
			AWIVClientRouter router = AWIVClientContext.getRouter();
			setTransactionContextProperties(transactionId, "getPatientLookupSites");
			List<ResolvedArtifactSource> artifactSources = router.getResolvedArtifactSourceList();
			Collections.sort(artifactSources, new ResolvedArtifactSourceComparator());
			return AwivClientTranslator.translatePatientSelectionSites(artifactSources);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}
	}	
}
