/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: 
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.Cookie;

import gov.va.med.RoutingToken;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.awiv.AWIVClientContext;
import gov.va.med.imaging.awiv.AWIVClientContextHolder;
import gov.va.med.imaging.awiv.AWIVClientRouter;
import gov.va.med.imaging.awiv.business.AwivAuthenticationSitesInformation;
import gov.va.med.imaging.awiv.business.AwivWelcomeMessage;
import gov.va.med.imaging.awiv.client.UserAuthenticationService;
import gov.va.med.imaging.awiv.client.ui.widgets.AwivConstants;
import gov.va.med.imaging.awiv.configuration.AwivClientConfiguration;
import gov.va.med.imaging.awiv.exceptions.AwivConnectionException;
import gov.va.med.imaging.awiv.exceptions.AwivCredentialsExpiredException;
import gov.va.med.imaging.awiv.exceptions.AwivInvalidUserCredentialsException;
import gov.va.med.imaging.awiv.exceptions.AwivMethodException;
import gov.va.med.imaging.awiv.server.translator.AwivClientTranslator;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.CredentialsExpiredException;
import gov.va.med.imaging.core.interfaces.exceptions.InvalidUserCredentialsException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.encryption.exceptions.AesEncryptionException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.exchange.business.WelcomeMessage;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmSecurityContext;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmPrincipal.AuthenticationCredentialsType;
import gov.va.med.imaging.tomcat.vistarealm.encryption.EncryptionToken;
import gov.va.med.imaging.transactioncontext.ClientPrincipal;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.url.vista.StringUtils;

public class UserAuthenticationServiceImpl 
extends AbstractAwivClientRemoteServiceServlet 
implements UserAuthenticationService 
{
	private static final long serialVersionUID = 5440456687906992028L;

	@Override
	public boolean authenticateUser(String transactionId, String siteNumber, String username,
			String password)
	throws AwivMethodException, AwivConnectionException, AwivInvalidUserCredentialsException,
	AwivCredentialsExpiredException
	{
		try
		{
			if(username != null && (password == null || password.length() <= 0))
			{
				// if the username has a value and the password does not the user might have put the entire
				// access/verify code pair into the username field (VistA supports this). In this case the two
				// are separated by a semicolon
				if(username.contains(new String(";")))
				{
					password = StringUtils.MagPiece(username, StringUtils.SEMICOLON, 2);							
					username = StringUtils.MagPiece(username, StringUtils.SEMICOLON, 1);
				}
			}			
			
			ClientPrincipal principal = new ClientPrincipal(
					siteNumber, true,AuthenticationCredentialsType.Password, 
					username, password,
					null, null, null, null, null,
					new ArrayList<String>(),
					new HashMap<String, Object>()
			);
			principal.setAuthenticatedByVista(true); // if all works this will be true
			VistaRealmSecurityContext.set(principal);
			//TransactionContextFactory.createClientTransactionContext(principal);
			TransactionContext transactionContext = TransactionContextFactory.get(); 
			transactionContext.setBrokerSecurityApplicationName("VISTA IMAGING VIX");
			transactionContext.setAccessCode(username);
			transactionContext.setVerifyCode(password);
			transactionContext.setSiteNumber(siteNumber);
			
			AWIVClientRouter router = AWIVClientContext.getRouter();
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber);
			setTransactionContextProperties(transactionId, "authenticateUser");
			router.authenticateUser(routingToken);
			Cookie cookie = new Cookie(AwivConstants.userCookieName, 
					EncryptionToken.encryptUserCredentials());
			cookie.setPath("/Awiv");
			//cookie.setSecure(true);
			cookie.setMaxAge(-1); // don't persist between sessions
			getThreadLocalResponse().addCookie(cookie);
			return true;
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new AwivMethodException(rtfX);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(InvalidUserCredentialsException iucX)
		{
			throw new AwivInvalidUserCredentialsException(iucX);
		}
		catch(CredentialsExpiredException ceX)
		{
			throw new AwivCredentialsExpiredException(ceX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}
		catch(AesEncryptionException arX)
		{
			throw new AwivMethodException(arX);
		}
	}

	@Override
	public AwivWelcomeMessage getWelcomeMessage(String transactionId,
			String siteNumber) 
	throws AwivMethodException, AwivConnectionException
	{
		try
		{
			AWIVClientRouter router = AWIVClientContext.getRouter();
			setTransactionContextProperties(transactionId, "getWelcomeMessage");
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber);
			WelcomeMessage welcomeMessage = router.getCachedWelcomeMessage(routingToken);
			return AwivClientTranslator.translate(welcomeMessage);
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new AwivMethodException(rtfX);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}		
	}

	@Override
	public AwivAuthenticationSitesInformation getUserAuthenticationSites(String transactionId)
	throws AwivMethodException, AwivConnectionException
	{
		try
		{
			AWIVClientRouter router = AWIVClientContext.getRouter();
			setTransactionContextProperties(transactionId, "getUserAuthenticationSites");
			List<ResolvedArtifactSource> artifactSources = router.getResolvedArtifactSourceList();
			Collections.sort(artifactSources, new ResolvedArtifactSourceComparator());
			String version = AWIVClientContextHolder.getAwivClientContext().getApplicationConfiguration().getVixSoftwareVersion();
			return AwivClientTranslator.translate(artifactSources, AwivClientConfiguration.getConfiguration(), version);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}
	}
}
