/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: 
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.server;

import java.util.Collections;
import java.util.List;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.awiv.AWIVClientContext;
import gov.va.med.imaging.awiv.AWIVClientRouter;
import gov.va.med.imaging.awiv.business.AwivSite;
import gov.va.med.imaging.awiv.client.PatientTreatingSitesService;
import gov.va.med.imaging.awiv.configuration.AwivClientConfiguration;
import gov.va.med.imaging.awiv.exceptions.AwivConnectionException;
import gov.va.med.imaging.awiv.exceptions.AwivMethodException;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.exchange.business.ResolvedSiteImpl;
import gov.va.med.imaging.exchange.business.SiteNumberArtifactSourceTranslator;
import gov.va.med.imaging.exchange.business.util.ExchangeUtil;

public class PatientTreatingSitesServiceImpl 
extends AbstractAwivClientRemoteServiceServlet 
implements PatientTreatingSitesService 
{

	private static final long serialVersionUID = 8526195486752176588L;

	@Override
	public AwivSite[] getPatientSites(String transactionId, String siteNumber, String patientIcn)
	throws AwivConnectionException, AwivMethodException
	{
		try
		{
			AWIVClientRouter router = AWIVClientContext.getRouter();
			setTransactionContextProperties(transactionId, "getTreatingSites", patientIcn);
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber);
			List<ResolvedArtifactSource> artifactSources = 
				router.getTreatingSites(routingToken, PatientIdentifier.icnPatientIdentifier(patientIcn), true, 
						new AwivClientSiteNumberTranslator());
			
			Collections.sort(artifactSources, new ResolvedArtifactSourceComparator());			
			AwivSite [] result = new AwivSite[artifactSources.size()];			
			for(int i = 0; i < artifactSources.size(); i++)
			{
				ResolvedSiteImpl resolvedSite = (ResolvedSiteImpl)artifactSources.get(i);
				
				result[i] = new AwivSite(resolvedSite.getSite().getSiteName(), 
						resolvedSite.getArtifactSource().createRoutingToken().toRoutingTokenString());
			}
			setEntriesReturned(result.length);
			
			return result;
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new AwivMethodException(rtfX);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}
	}
	
	class AwivClientSiteNumberTranslator
	extends SiteNumberArtifactSourceTranslator
	{

		/* (non-Javadoc)
		 * @see gov.va.med.imaging.exchange.business.SiteNumberArtifactSourceTranslator#translateSiteNumberToArtifactSourceSiteNumber(java.lang.String)
		 */
		@Override
		public String translateSiteNumberToArtifactSourceSiteNumber(String siteNumber)
		{
			if(siteNumber == null)
				return null; // never should happen - just in case
			
			if(siteNumber.contains(ExchangeUtil.getDodSiteNumber()))
			{
				String [] allowedDoDSiteNumbers = AwivClientConfiguration.getConfiguration().getAllowedDoDSiteNumbers();
				if(allowedDoDSiteNumbers != null)
				{
					for(String allowedDoDSiteNumber : allowedDoDSiteNumbers)
					{
						if(allowedDoDSiteNumber.equals(siteNumber))
						{
							// this site number will properly resolve to an Artifact Source
							return ExchangeUtil.getDodSiteNumber();
						}
					}
				}
				// site number not allowed, don't try to use it
				return null;
			}
			else
			{
				// VA site number, leave as is
				return siteNumber;
			}
		}
		
	}
}
