/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: 
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.server;

import java.util.List;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.awiv.AWIVClientContext;
import gov.va.med.imaging.awiv.AWIVClientRouter;
import gov.va.med.imaging.awiv.business.AwivMeansTestResult;
import gov.va.med.imaging.awiv.business.AwivPatientSensitivity;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.client.PatientLookupService;
import gov.va.med.imaging.awiv.exceptions.AwivConnectionException;
import gov.va.med.imaging.awiv.exceptions.AwivMethodException;
import gov.va.med.imaging.awiv.server.translator.AwivClientTranslator;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.exchange.business.PatientMeansTestResult;
import gov.va.med.imaging.exchange.business.PatientSensitiveValue;

public class PatientLookupServiceImpl 
extends AbstractAwivClientRemoteServiceServlet 
implements PatientLookupService 
{

	private static final long serialVersionUID = -7061736772132797551L;

	@Override
	public Patient[] search(String transactionId, String siteNumber, String searchString)
	throws AwivMethodException, AwivConnectionException
	{
		try
		{
			setTransactionContextProperties(transactionId, "searchPatient");
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber);
			AWIVClientRouter router = AWIVClientContext.getRouter();
			List<gov.va.med.imaging.exchange.business.Patient> patients = router.getPatientList(searchString, routingToken);
			Patient [] result = AwivClientTranslator.translatePatients(patients);
			setEntriesReturned(result.length);
			return result;
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new AwivMethodException(rtfX);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientLookupService#getPatientInformation(java.lang.String, java.lang.String)
	 */
	@Override
	public Patient getPatientInformation(String transactionId, String siteNumber, String patientIcn)
	throws AwivMethodException, AwivConnectionException
	{
		try
		{
			setTransactionContextProperties(transactionId, "getPatientInformation", patientIcn);
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber);
			AWIVClientRouter router = AWIVClientContext.getRouter();
			
			gov.va.med.imaging.exchange.business.Patient patient = router.getPatientInformation(routingToken, 
					PatientIdentifier.icnPatientIdentifier(patientIcn));
			Patient result = AwivClientTranslator.translate(patient);
			setEntriesReturned(1);
			return result;
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new AwivMethodException(rtfX);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.PatientLookupService#getPatientSensitivity(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public AwivPatientSensitivity getPatientSensitivity(String transactionId,
			String siteNumber, String patientIcn) 
	throws AwivMethodException, AwivConnectionException
	{
		try
		{
			setTransactionContextProperties(transactionId, "getPatientSensitivity", patientIcn);
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber);
			AWIVClientRouter router = AWIVClientContext.getRouter();			
			PatientSensitiveValue patientSensitivityValue = router.getPatientSensitivityLevel(routingToken, 
					PatientIdentifier.icnPatientIdentifier(patientIcn));			
			AwivPatientSensitivity result = AwivClientTranslator.translate(patientSensitivityValue);
			return result;
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new AwivMethodException(rtfX);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}
	}

	@Override
	public boolean logPatientSensitiveAccess(String transactionId,
			String siteNumber, String patientIcn) 
	throws AwivMethodException, AwivConnectionException
	{
		try
		{
			setTransactionContextProperties(transactionId, "logPatientSensitiveAccess", patientIcn);
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber);
			AWIVClientRouter router = AWIVClientContext.getRouter();			
			
			Boolean result = router.postSensitivePatientAccess(routingToken, 
					PatientIdentifier.icnPatientIdentifier(patientIcn));
			return result;
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new AwivMethodException(rtfX);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}
	}

	@Override
	public AwivMeansTestResult getPatientMeansTest(String transactionId,
			String siteNumber, String patientIcn) 
	throws AwivMethodException, AwivConnectionException
	{
		try
		{
			setTransactionContextProperties(transactionId, "getPatientMeansTest", patientIcn);
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber);
			AWIVClientRouter router = AWIVClientContext.getRouter();	
			PatientMeansTestResult result = 
				router.getPatientMeansTest(routingToken, 
						PatientIdentifier.icnPatientIdentifier(patientIcn));
			return AwivClientTranslator.translate(result);			
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new AwivMethodException(rtfX);
		}
		catch(ConnectionException cX)
		{
			throw new AwivConnectionException(cX);
		}
		catch(MethodException mX)
		{
			throw new AwivMethodException(mX);
		}
	}
}
