/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 21, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.encryption;

import java.util.ArrayList;
import java.util.HashMap;

import gov.va.med.imaging.encryption.AesEncryption;
import gov.va.med.imaging.encryption.exceptions.AesEncryptionException;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmSecurityContext;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmPrincipal.AuthenticationCredentialsType;
import gov.va.med.imaging.transactioncontext.ClientPrincipal;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.url.vista.StringUtils;

/**
 * @author       DNS
 *
 */
public class EncryptionToken
{
	private final static String delimiter = "||";
	
	public static String encryptUserCredentials()
	throws AesEncryptionException
	{
		StringBuilder sb = new StringBuilder();
		TransactionContext transactionContext = TransactionContextFactory.get();
		sb.append(transactionContext.getFullName()); //0
		sb.append(delimiter);
		sb.append(transactionContext.getDuz()); // 1
		sb.append(delimiter);
		sb.append(transactionContext.getSsn()); // 2
		sb.append(delimiter);
		sb.append(transactionContext.getSiteName()); // 3
		sb.append(delimiter);
		sb.append(transactionContext.getSiteNumber()); // 4
		sb.append(delimiter);
		sb.append(transactionContext.getBrokerSecurityToken()); // 5
		sb.append(delimiter);
		sb.append(transactionContext.getAccessCode() == null ? "" : transactionContext.getAccessCode()); //6
		sb.append(delimiter);
		sb.append(transactionContext.getVerifyCode() == null ? "" : transactionContext.getVerifyCode()); // 7
		return AesEncryption.encrypt(sb.toString());
	}
	
	public static void decryptUserCredentials(String encryptedParameters)
	throws AesEncryptionException
	{
		// decrypt and put into transaction context
		String decryptedParameters = AesEncryption.decrypt(encryptedParameters);		
		String [] pieces = StringUtils.Split(decryptedParameters, delimiter);		
		
		String fullName = pieces[0];
		String duz = pieces[1];
		String ssn = pieces[2];
		String siteName = pieces[3];
		String siteNumber = pieces[4];
		String brokerSecurityToken = pieces[5];
		
		String accessCode = pieces[6];
		if(accessCode != null && accessCode.length() <= 0)
			accessCode = null;
		String verifyCode = pieces[7];
		if(verifyCode != null && verifyCode.length() <= 0)
			verifyCode = null;
		
		ClientPrincipal principal = new ClientPrincipal(
				siteNumber, true,AuthenticationCredentialsType.Password, 
				accessCode, verifyCode,
				duz, fullName, ssn, siteNumber, siteName,
				new ArrayList<String>(),
				new HashMap<String, Object>()
		);
		principal.setAuthenticatedByVista((accessCode != null && verifyCode != null)); // true if access code and verify code are specified
		VistaRealmSecurityContext.set(principal);
		
		//TransactionContextFactory.createClientTransactionContext(principal);
		TransactionContext transactionContext = TransactionContextFactory.get(); 
		transactionContext.setBrokerSecurityApplicationName("VISTA IMAGING VIX");
		
		/*
		transactionContext.setFullName(pieces[0]);
		transactionContext.setDuz(pieces[1]);
		transactionContext.setSsn(pieces[2]);
		transactionContext.setSiteName(pieces[3]);
		transactionContext.setSiteNumber(siteNumber);
		*/
		transactionContext.setBrokerSecurityToken(brokerSecurityToken);
	}

}
