/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 11, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.configuration;

import gov.va.med.imaging.facade.configuration.AbstractBaseFacadeConfiguration;
import gov.va.med.imaging.facade.configuration.FacadeConfigurationFactory;
import gov.va.med.imaging.facade.configuration.exceptions.CannotLoadConfigurationException;
import gov.va.med.imaging.webservices.clinical.AbstractClinicalWebAppConfiguration;

/**
 * @author       DNS
 *
 */
public class AwivClientConfiguration
extends AbstractClinicalWebAppConfiguration 
{
	private String siteServiceUrl;
	private String cvixSiteNumber;
	private String [] allowedDoDSiteNumbers;
	private int idleTimeoutMinutes;
	private int sslPort;
	private boolean ieOnly;
	private boolean useSilverlightPlugin;
	private boolean checkMeansTest;

	public AwivClientConfiguration()
	{
		super();
	}
	
	public synchronized static AwivClientConfiguration getConfiguration()	
	{
		try
		{
			return FacadeConfigurationFactory.getConfigurationFactory().getConfiguration(
					AwivClientConfiguration.class);
		}
		catch(CannotLoadConfigurationException clcX)
		{
			// no need to log, already logged
			return null;
		}
	}

	public static void main(String [] args)
	{
		AwivClientConfiguration config = getConfiguration();
		config.storeConfiguration();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.webservices.clinical.AbstractClinicalWebAppConfiguration#loadDefaultConfiguration()
	 */
	@Override
	public AbstractBaseFacadeConfiguration loadDefaultConfiguration()
	{
		super.loadDefaultConfiguration();
		this.siteServiceUrl = "http://DNS.DNS      .DNS   /VistaWebSvcs/ImagingExchangeSiteService.asmx";
		this.cvixSiteNumber = "2001";
		this.allowedDoDSiteNumbers = new String [] {"200", "200DOD"};
		this.idleTimeoutMinutes = 20;
		this.sslPort = PORT;
		this.ieOnly = true;
		this.useSilverlightPlugin = false;
		this.checkMeansTest = true;
		return this;
	}

	/**
	 * The URL to provide to the AWIV to find the site service (default is http://DNS.DNS      .DNS   /VistaWebSvcs/ImagingExchangeSiteService.asmx)
	 * 
	 * @return the siteServiceUrl
	 */
	public String getSiteServiceUrl()
	{
		return siteServiceUrl;
	}

	/**
	 * @param siteServiceUrl the siteServiceUrl to set
	 */
	public void setSiteServiceUrl(String siteServiceUrl)
	{
		this.siteServiceUrl = siteServiceUrl;
	}
	
	/**
	 * Site number to use provide to the AWIV component to find the CVIX in the site service (default is 2001)
	 * 
	 * @return the cvixSiteNumber
	 */
	public String getCvixSiteNumber()
	{
		return cvixSiteNumber;
	}

	/**
	 * @param cvixSiteNumber the cvixSiteNumber to set
	 */
	public void setCvixSiteNumber(String cvixSiteNumber)
	{
		this.cvixSiteNumber = cvixSiteNumber;
	}

	/**
	 * This specifies the entries in the TFL that indicate the patient has been seen at the DoD. By default this 
	 * value is 200 and 200DOD
	 * 
	 * @return the allowedDoDSiteNumbers
	 */
	public String[] getAllowedDoDSiteNumbers()
	{
		return allowedDoDSiteNumbers;
	}

	/**
	 * @param allowedDoDSiteNumbers the allowedDoDSiteNumbers to set
	 */
	public void setAllowedDoDSiteNumbers(String[] allowedDoDSiteNumbers)
	{
		this.allowedDoDSiteNumbers = allowedDoDSiteNumbers;
	}

	/**
	 * The amount of time (in minutes) between calls to the server before the application will timeout. By default
	 * this value is 20
	 * 
	 * @return the idleTimeoutMinutes
	 */
	public int getIdleTimeoutMinutes()
	{
		return idleTimeoutMinutes;
	}

	/**
	 * @param idleTimeoutMinutes the idleTimeoutMinutes to set
	 */
	public void setIdleTimeoutMinutes(int idleTimeoutMinutes)
	{
		this.idleTimeoutMinutes = idleTimeoutMinutes;
	}

	/**
	 * The port to use to redirect the user for an SSL connection. By default this is 443
	 * 
	 * @return the sslPort
	 */
	public int getSslPort()
	{
		return sslPort;
	}

	/**
	 * @param sslPort the sslPort to set
	 */
	public void setSslPort(int sslPort)
	{
		this.sslPort = sslPort;
	}

	/**
	 * Determines if IE is the only supported browser for viewing patient images. Default value is true
	 * 
	 * @return the ieOnly
	 */
	public boolean isIeOnly()
	{
		return ieOnly;
	}

	/**
	 * @param ieOnly the ieOnly to set
	 */
	public void setIeOnly(boolean ieOnly)
	{
		this.ieOnly = ieOnly;
	}

	/**
	 * Determines if the silverlight plugin should be used for displaying images rather than the ActiveX control
	 * @return the useSilverlightPlugin
	 */
	public boolean isUseSilverlightPlugin()
	{
		return useSilverlightPlugin;
	}

	/**
	 * @param useSilverlightPlugin the useSilverlightPlugin to set
	 */
	public void setUseSilverlightPlugin(boolean useSilverlightPlugin)
	{
		this.useSilverlightPlugin = useSilverlightPlugin;
	}

	/**
	 * Indicates if the means test check should be done. By default this is true
	 * 
	 * @return the checkMeansTest
	 */
	public boolean isCheckMeansTest()
	{
		return checkMeansTest;
	}

	/**
	 * @param checkMeansTest the checkMeansTest to set
	 */
	public void setCheckMeansTest(boolean checkMeansTest)
	{
		this.checkMeansTest = checkMeansTest;
	}
}
