/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 12, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets.dialogs;

import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.Window;

/**
 * Dialog to show to the user when loading information.
 * 
 * @author       DNS
 *
 */
public class WaitDialog
extends Window
{
	private static WaitDialog waitDialog = null;
	
	/**
	 * display the wait dialog with the given message
	 * @param title
	 * @param message
	 */
	public static void displayWaitDialog(String title, String message)
	{
		hideWaitDialog();
		waitDialog = new WaitDialog(title, message);
		waitDialog.show();
	}
	
	/**
	 * Hide the wait dialog
	 */
	public static void hideWaitDialog()
	{
		if(waitDialog != null)
			waitDialog.hide();
	}
	
	private WaitDialog(String title, String message)
	{
		this.setWidth(360);  
		this.setHeight(115);  
		this.setTitle(title);  
		this.setShowMinimizeButton(false);
		this.setShowCloseButton(false);
		this.setIsModal(true);  
		this.setShowModalMask(true);  
		this.centerInPage();  
        
        Label label = new Label(message);  
        label.setHeight100();  
        label.setPadding(5);  
        label.setValign(VerticalAlignment.TOP);  
        
        this.addItem(label);  
	}

}
