/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 9, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets.dialogs;

import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.ui.widgets.AwivViewerManager;

import com.google.gwt.user.client.Timer;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;

/**
 * This dialog displays a warning that the user has been idle for too long and asks if they want to continue to stay connected. 
 * 
 * If the user does not respond within a minute they are automatically logged out
 * 
 * @author       DNS
 *
 */
public class TimeoutWarningDialog
implements BooleanCallback
{
	/**
	 * Show the session timeout dialog, this dialog will log the user out if they do not response soon enough
	 */
	public static void show()
	{
		TimeoutWarningDialog warningDialog = new TimeoutWarningDialog();
		warningDialog.showTimerWarning();
	}	
	
	private Timer timer = null;
	private boolean stayConnected = false;
	
	/**
	 * Display the dialog
	 */
	private void showTimerWarning()
	{
		AwivHelper.stopSessionTimer();
		timer = new Timer()
		{
			@Override
			public void run()
			{
				if(!stayConnected)
				{					
					// user waited too long, close the AWIV
					//Window.alert("timer.run() fired, stayConnected is: " + stayConnected);
					AwivHelper.logout();
				}
			}
		};
		timer.schedule(1000 * 60); // 1 minute
		stayConnected = false;
		SC.ask("Idle Session", 
				"Your session has been idle for " + AwivHelper.getSessionTimeout() + " minutes, do you want to remain connected?<br>You will be automatically logged out if you do not respond within 1 minute", 
				this);
	}

	/* (non-Javadoc)
	 * @see com.smartgwt.client.util.BooleanCallback#execute(java.lang.Boolean)
	 */
	@Override
	public void execute(Boolean value)
	{
		if(timer != null)
		{
			timer.cancel();			
			//Window.alert("Timer is not null, cancel called");
		}
		timer = null;
		stayConnected = true;
		if(value != null && value.booleanValue() == true)
		{
			// remain connected, ping the server to keep the session alive
			//AwivHelper.pingServer(); // no longer ping without sessions
			AwivHelper.resetSessionTimer();		
			AwivViewerManager.bringAwivToFront();
		}
		else
		{
			// user didn't want to stay connected, disconnect
			AwivHelper.logout();
			// logout calls reloadAwiv()
			//AwivHelper.reloadAwiv();
		}	
	}
}
